/*
    Copyright (c) 2011 Andy Kirkham
 
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:
 
    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.
 
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.
*/


#ifndef AJK_SIMPLESTEPERPROFILER_H
#define AJK_SIMPLESTEPERPROFILER_H

#include "mbed.h"
#include "SimpleSteppers.h"

namespace AjK {

class SimpleStepperProfiler : public SimpleStepper {

protected:
    Ticker  _poll;
    int     _desired_speed;
    int     _step_pos;
    int     _step_neg;
    int     _poll_interval;

    void poll(void) 
    {
        if (_steps_per_second < _desired_speed) {
            _steps_per_second += _step_pos;
            if (_steps_per_second > _desired_speed) {
                _steps_per_second = _desired_speed;
            }
            SimpleStepper::setSpeed(_steps_per_second);
        }
        if (_steps_per_second > _desired_speed) {
            _steps_per_second -= _step_neg;
            if (_steps_per_second < _desired_speed) {
                _steps_per_second = _desired_speed;
            }
            SimpleStepper::setSpeed(_steps_per_second);
        }
    }
    
public:

    friend class Ticker;
    
    SimpleStepperProfiler(PinName pulse, SimpleStepperOutput *direction = 0) : 
        SimpleStepper(pulse, direction) 
    {
        _desired_speed = 0;
        _step_pos      = 10;
        _step_neg      = 10;
        _poll_interval = 10000; // 10ms
        _poll.attach_us(this, &SimpleStepperProfiler::poll, _poll_interval);   
    }
    
    int  getStepPos(void)  { return _step_pos; }
    void setStepPos(int i) { _step_pos = i; }
    
    int  getStepNeg(void)  { return _step_neg; }
    void setStepNeg(int i) { _step_neg = i; }
    
    int  getPollInterval(void)  { return _poll_interval; }
    void setPollInterval(int i) 
    { 
        _poll_interval = i;
        _poll.detach();
        _poll.attach_us(this, &SimpleStepperProfiler::poll, _poll_interval);
    }
    
    void setSpeed(int steps_per_second = 0, uint32_t raw = 0)
    {
        _desired_speed = steps_per_second;
    }
    
    void eStop(void) 
    {
        _desired_speed = _steps_per_second = 0;
        SimpleStepper::setSpeed(_steps_per_second);
    }
    
   
};

}; // namespace AjK ends.


#endif
