
#include "mbed.h"
#include "SimpleStepperProfiler.h"

SimpleStepperOutput led1(LED1);

// SimpleStepperOutput is basically the same as
// Mbed's DigitalOut class. However, it's more
// portable to other platforms without having
// to also port the entire Mbed library.
SimpleStepperOutput sdir0(p17);

// Create four stepper profilers.
// Stepper0 has the pulse output on p8 and dir on p17
SimpleStepperProfiler stepper0(p8, &sdir0);

int main() {
    
    // We do not need to maintain the stepper position
    // for this simple example. This reduces the amount
    // of work the ISR has to do.
    stepper0.setMaintainPositionData(false);
    
    // Set all steppers to top speed of 5000 pulses/second.
    // Because we are using the SimpleStepperProfiler then
    // the accel will be 1000pps/s, so to reach 5000pps will
    // take 5seconds.
    
    // The accel profile can be adjusted by altering the profilers
    // step value and poll interval. The default step value is 10
    // each poll interval and the default poll interval is 10ms.
    // This equates to 100 * 10 = 1000pps/s. Adjust as required
    // using :-
    //   setStepPos(int i); where i is the step value +/- each poll interval accel
    //   setStepNeg(int i); where i is the step value +/- each poll interval decel
    //   setPollInterval(int i) where i is the poll interval in microseconds.
    
    stepper0.setSpeed(5000);
    while(stepper0.getSpeed() != 5000); // wait to reach speed.
    
    // Decel stepper to halt/stop.
    stepper0.setSpeed(0);
    while(stepper0.getSpeed() != 0); // wait to reach speed.
    
    // Set speed but peform async emergency stop while accelerating.
    stepper0.setSpeed(5000);
    wait(2.5);
    stepper0.eStop();
    
    while(1) {
        led1 = !led1;
        wait(0.2);        
    }
}
