/*
    Copyright (c) 2011 Andy Kirkham
 
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:
 
    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.
 
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.
    
    @file          example2.h 
    @purpose       Simple round-robin cooperative scheduler example
    @date          Mar 2011
    @author        Andy Kirkham
*/

/* This example shows how to call tasks defined as C++ class methods. */

#include "mbed.h"
#include "SimpleScheduler.h"

// Task class example.
class Foo {
protected:
    DigitalOut *_do;
public:
    Foo(DigitalOut *d) { _do = d; }
    void func(SimpleTask *task) { *_do = !*_do; }
};

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

Foo foo1(&led1);
Foo foo2(&led2);
Foo foo3(&led3);
Foo foo4(&led4);

SimpleScheduler *scheduler;

int main() {

    scheduler = new SimpleScheduler;
    
    scheduler
        ->addTask( new SimpleTask(0,   &foo1, &Foo::func) )
        ->addTask( new SimpleTask(200, &foo2, &Foo::func) )
        ->addTask( new SimpleTask(300, &foo3, &Foo::func) )
        ->addTask( new SimpleTask(0.4, &foo4, &Foo::func) )
    ;
    
    scheduler->run();    
}
