/*
    Copyright (c) 2011 Andy Kirkham
 
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:
 
    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.
 
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.
    
    @file          example1.h 
    @purpose       Simple round-robin cooperative scheduler example
    @date          Mar 2011
    @author        Andy Kirkham
*/

/* This example shows how to call tasks defined as C functions. */

#include "mbed.h"
#include "SimpleScheduler.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

void f1(SimpleTask *task) { led1 = !led1; }
void f2(SimpleTask *task) { led2 = !led2; }
void f3(SimpleTask *task) { led3 = !led3; }
void f4(SimpleTask *task) { led4 = !led4; }

SimpleScheduler *scheduler;

int main() {

    scheduler = new SimpleScheduler;
    
    scheduler
        ->addTask( new SimpleTask(0,   f1) )
        ->addTask( new SimpleTask(200, f2) )
        ->addTask( new SimpleTask(300, f3) )
        ->addTask( new SimpleTask(0.4, f4) )
    ;
    
    scheduler->run();    
}
