/*
    Copyright (c) 2011 Andy Kirkham
 
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:
 
    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.
 
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.
*/

#include "mbed.h"
#include "SimpleRCservos.h"

#define N_90 -90.0
#define P_90 +90.0

SimpleRCservos servos;

int main() {
    double position = 0;

    // The default scaling range is -1.0 to +1.0
    // Alter the scaling range to -90.0 to +90.0
    servos.setLimits(SimpleRCservos::Servo6, N_90, P_90); // Mbed p21
    servos.setLimits(SimpleRCservos::Servo5, N_90, P_90); // Mbed p22
    servos.setLimits(SimpleRCservos::Servo4, N_90, P_90); // Mbed p23
    
    // The default range is 1ms to 2ms with 1.5ms being the neutral.
    // This line isn't actually needed as 1ms/2ms is the library's 
    // default but is included here to show how altering it may be
    // achieved.
    servos.setRange(SimpleRCservos::Servo6, 1000, 2000); // Servo6 uses p21
    
    // Add a servo pulse range, 900us to 2.1ms, neutral 1.5ms.
    servos.setRange(SimpleRCservos::Servo5, 900, 2100); // Servo5 uses p22
    
    // Add a servo pulse range, 600us to 2.4ms, neutral 1.5ms.
    servos.setRange(SimpleRCservos::Servo4, 600, 2400); // Servo4 uses p23
    
    // Enable the Servo (starts producing pulses).
    servos.enable(SimpleRCservos::Servo6);
    servos.enable(SimpleRCservos::Servo5);
    servos.enable(SimpleRCservos::Servo4);
    
    while(1) {
        
        // Slide up to max
        for(position = 0; position < P_90; position += 0.1) {
            servos.position(SimpleRCservos::Servo6, position);
            servos.position(SimpleRCservos::Servo5, position);
            servos.position(SimpleRCservos::Servo4, position);
            wait(0.005);
        }
        wait(2);
        
        // Slide down to min
        for(position = P_90; position > N_90; position -= 0.1) {
            servos.position(SimpleRCservos::Servo6, position);
            servos.position(SimpleRCservos::Servo5, position);
            servos.position(SimpleRCservos::Servo4, position);
            wait(0.005);
        }
        wait(2);
        
        // Slide back up to neutral
        for(position = N_90; position < 0; position += 0.1) {
            servos.position(SimpleRCservos::Servo6, position);
            servos.position(SimpleRCservos::Servo5, position);
            servos.position(SimpleRCservos::Servo4, position);
            wait(0.005);
        }
        wait(2); 
    }       
}

