/*
    Copyright (c) 2011 Andy Kirkham
 
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:
 
    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.
 
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.
*/

// Dervived from http://mbed.org/forum/helloworld/topic/2303

#include "mbed.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);

#include "SimpleRCservos.h"
#include "SimpleServoControl.h"

SimpleRCservos servos;

SimpleServoControl motor_front_left(&servos, SimpleRCservos::Servo6); // p21
SimpleServoControl motor_front_right(&servos, SimpleRCservos::Servo5); // p22
SimpleServoControl motor_rear_left(&servos, SimpleRCservos::Servo4); // p23
SimpleServoControl motor_rear_right(&servos, SimpleRCservos::Servo3); // p24

int main() 
{
    // Led1 on to show program start.
    led1 = 1;
    
    motor_front_left.position(90.0);
    motor_front_right.position(90.0);
    motor_rear_left.position(90.0);
    motor_rear_right.position(90.0);
    
    // Led2 on when rotate complete and program ended.
    led2 = 1;
    
    // End, loop forever.
    while(1);
}
