/****************************************************************************
 *    Copyright 2010 Andy Kirkham, Stellar Technologies Ltd
 *    
 *    This file is part of the Satellite Observers Workbench (SOWB).
 *
 *    SOWB is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    SOWB is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with SOWB.  If not, see <http://www.gnu.org/licenses/>.
 *
 *    $Id: main.cpp 5 2010-07-12 20:51:11Z ajk $
 *    
 ***************************************************************************/

/* Sadly stung by the Mbed libraries again. The sheer number
   of interrupts running on SOWB are incomp with the LocalFileSystem
   library which simply crashes the entire project. 
   
   Need to get down to the electonics shop and buy myself some flash
   and DIY my own solution again. Sigh... */
   
#ifdef NEVERCOMPILETHIS

#include "mbed.h"
#include "mbedfilesys.h"
#include "user.h"
#include "utils.h"
#include "gpio.h"
#include "debug.h"

LocalFileSystem local("local");

inline void disable_irqs(void) {
    NVIC_DisableIRQ(EINT3_IRQn);
    NVIC_DisableIRQ(RIT_IRQn);
    NVIC_DisableIRQ(UART0_IRQn);
    NVIC_DisableIRQ(UART1_IRQn);
    NVIC_DisableIRQ(UART2_IRQn);
    NVIC_DisableIRQ(USB_IRQn);
}

inline void enable_irqs(void) {
    NVIC_EnableIRQ(USB_IRQn);
    NVIC_EnableIRQ(EINT3_IRQn);
    NVIC_EnableIRQ(RIT_IRQn);
    NVIC_EnableIRQ(UART0_IRQn);
    NVIC_EnableIRQ(UART1_IRQn);
    NVIC_EnableIRQ(UART2_IRQn);
}

static int get_tle_from_file(const char *filename, int index, SAT_POS_DATA *sat) {
    FILE *fp;
    char *r, line[128];
    int  line_count = 0, sat_count = 0;

    fp = fopen(filename, "r");
    if (!fp) {
        return SOWB_FILE_NOT_FOUND;
    }
    else {
	    while (!feof(fp)) {
	        LED1_ON;
            disable_irqs();
            r = fgets(line, 127, fp);
            enable_irqs();
            LED1_OFF;
	        if(!fgets(line, 127, fp)) {
	            fclose(fp);
	            return SOWB_FILE_EOF_REACHED;
	        }
	        else {
		        switch(line_count) {
		            case 0: strncpy(sat->elements[0], line, 80); break;
		            case 1: strncpy(sat->elements[1], line, 80); break;
		            case 2: strncpy(sat->elements[2], line, 80); break;
		        }
		        line_count++;
		        if (line_count == 3) {
		            if (sat_count == index) {
		                fclose(fp);
		                return SOWB_FILE_OK;
		            }
		            line_count = 0;
		            sat_count++;
		        }
	        }
	    }
    }
    
    fclose(fp);
    return SOWB_FILE_INDEX_NOT_FOUND;   
}

/* Used to hold the index across first/next calls. */
int satllite_index;

int get_first_tle_from_file(const char *filename, SAT_POS_DATA *sat) {
    satllite_index = 0;
    return get_tle_from_file(filename, satllite_index, sat);
}

int get_next_tle_from_file(const char *filename, SAT_POS_DATA *sat) {
    satllite_index++;
    return get_tle_from_file(filename, satllite_index, sat);
}

void process_tle(SAT_POS_DATA *sat) {
    char line[128]; 

    /* Wait until time and location are valid. */
    do { 
        observer_now(sat);    
        user_call_process(); 
    } 
    while (!sat->time.is_valid || !sat->location.is_valid);

    debug_printf(" A %d\r\n", sizeof(SAT_POS_DATA));
    debug_printf(" A %s", sat->elements[0]);
    debug_printf(" A %s", sat->elements[1]);
    debug_printf(" A %s", sat->elements[2]);
    time_AsString(&sat->time, line);
    debug_printf(" A AT %s\r\n", line);
    sprintf(line, " A LAT %.4f\r\n", sat->location.latitude);  debug_printf("%s", line);
    sprintf(line, " A LON %.4f\r\n", sat->location.longitude); debug_printf("%s", line);
    sprintf(line, " A HEI %.4f\r\n", sat->location.height);    debug_printf("%s", line);
        
    sat->tsince = 0;
    satallite_calculate(sat);
    debug_stringl(line, sprintf(line, "   Azmith %.1f Elevation %.1f\r\n", sat->azimuth, sat->elevation));
}

#endif


