
#include "Roomba.h"

DigitalOut myled(LED1);
Roomba roomba(p9, p10);

int main() {

    // Examples of sending commands. Note that when
    // teh function returns, if it was successful
    // it returns the command code. Otherwise it 
    // will return Roomba::NotIdle which means it
    // couldn't send the command because the serial
    // port was busy reading sensor data.
    int result = roomba.command(Roomba::CmdPower);
    if (result != Roomba::CmdPower) {
        // Failed to send command because the 
        // serial port was busy getting sensor data
    }
    
    // A sure fire way to make the command happen.
    while (roomba.command(Roomba::CmdPower) != Roomba::CmdPower);
    
    // Some commands have additional bytes, heres an example
    char leds[3];
    leds[0] = 0x01; // First byte sent
    leds[1] = 0x05;
    leds[2] = 0x76; // Last byte sent
    roomba.command(Roomba::CmdLeds, 3, leds);
        
    // Sensors are read automartically. Here's how we
    // get the wall sensor and voltage values.    
    uint8_t  wall    = roomba.sensor(Roomba::wall);    
    uint16_t voltage = roomba.sensor(Roomba::voltage);
    
    // Note, when reading sensor data make sure your variable
    // is of the right type, either uint8_t for single byte
    // and uint16_t for double byte variables. 
      
    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);    
    }
}
