/*
    Copyright (c) 2010 Andy Kirkham
 
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:
 
    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.
 
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.
    
    @file          Roomba.h
    @purpose       http://mbed.org/forum/mbed/topic/1476
    @version       0.1 (untested)
    @date          Dec 2010
    @author        Andy Kirkham    
    @see           http://mbed.org/forum/mbed/topic/1476 
    @require       http://mbed.org/cookbook/MODSERIAL
*/

#ifndef ROOMBA_H
#define ROOMBA_H

#include "mbed.h"
#include "MODSERIAL.h"

/**
 * @brief Class efinition of a Roomba robot.
 * @author Andy Kirkham
 * @see http://mbed.org/forum/mbed/topic/1476
 * @see http://mbed.org/cookbook/MODSERIAL
 *
 * <b>Roomba</b> manages communications with teh robot.
 * It exports a simple API to send commands or read
 * sensor data.
 *
 * This module requires MODSERIAL
 */
class Roomba {
public:

    // States (and commands)
    enum RoombaState { 
          Idle = 0
        , GetSensors
        , CmdStart = 128
        , CmdBaud
        , CmdControl
        , CmdSafe
        , CmdFull
        , CmdPower
        , CmdSpot
        , CmdClean
        , CmdMax
        , CmdDrive
        , CmdMotors
        , CmdLeds
        , CmdSong
        , CmdPlay
        , CmdSensors
        , CmdForceSeekingDock        
    };
    
    // Calltypes and return types
    enum CallType {
          NotIdle = -1
        , Ok = 0
        , Invoke = 1
        , SerialCallback    
    };
    
    
    // Indexes into array to select what var
    enum Sensor8bit {
          bumpsWheeldrops = 0
        , wall
        , cliffLeft
        , cliffFrontLeft
        , cliffFrontRight
        , cliffRight
        , virtualWall
        , motorOvercurrents
        , dirtDetectorLeft
        , dirtDetectorRight
        , remoteControlCommand
        , buttons
        , chargingState
        , temperature
        , NumOf8bitSensors
    };
    
    // Indexes into array to select what var
    enum Sensor16bit {
          distance
        , angle
        , voltage
        , charge        
        , current
        , capacity        
        , NumOf16bitSensors
    };
    
    Roomba(PinName tx, PinName rx) { init(tx, rx); }
    ~Roomba() { delete uart; delete tick; }
    
    int command(RoombaState cmd, int opts = 0, char *opt = (char *)NULL, bool block = true);
    
    uint8_t  sensor(Sensor8bit  idx) { return sensors8bit[idx]; }
    uint16_t sensor(Sensor16bit idx) { return sensors16bit[idx]; }
    
    // Interrupt callback functions.
    void cbSerial(void) { cmdSensors(SerialCallback); }
    void cbTicker(void) { cmdSensors(Invoke); } ;
    
protected:
    int state;
    MODSERIAL *uart;
    Ticker    *tick;
    
    // Internal methods
    void init(PinName tx, PinName rx);
    int  cmdSensors(CallType type);

    // Sensor values. Populated with data
    // via ticker/serial interrupts. Available
    // to the user program via the .sensor() API
    // function.
    uint8_t  sensors8bit[NumOf8bitSensors];
    uint16_t sensors16bit[NumOf16bitSensors];
};

#endif
