/*
    Copyright (c) 2011 Andy Kirkham
 
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:
 
    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.
 
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.
*/

// Mimic Mbed's Ticker class but using RIT
// (note, only goes to milliseconds level not microseconds!)

#include "Ricker.h"

namespace AjK {

// Create a RickerSys controller.
RickerSys _rickerSys;

// Nice and simple ISR, just call the class standard handler.
extern "C" void RIT_IRQHandler(void) __irq 
{
    _rickerSys.isr();    
}

RickerSys::RickerSys()
{    
    LPC_SC->PCONP |= (1UL << 16);   // RIT On
    
    switch ((LPC_SC->PCLKSEL1 >> 26) & 0x3) {
        case 0: LPC_RIT->RICOMPVAL = (SystemCoreClock / 4 / 1000); break; /* CCLK / 4 */
        case 1: LPC_RIT->RICOMPVAL = (SystemCoreClock / 1 / 1000); break; /* CCLK / 1 */
        case 2: LPC_RIT->RICOMPVAL = (SystemCoreClock / 2 / 1000); break; /* CCLK / 2 */
        case 3: LPC_RIT->RICOMPVAL = (SystemCoreClock / 8 / 1000); break; /* CCLK / 8 */
    }
    
    NVIC_EnableIRQ(RIT_IRQn);
    LPC_RIT->RICTRL = 0x0000000A;
}

void 
RickerSys::addTicker(Ricker *t)
{
    rickers.push_back(t);   
}

void 
RickerSys::delTicker(Ricker *t)
{
    for (list<Ricker *>::iterator itor = rickers.begin(); itor != rickers.end(); ++itor) {
        if ((*itor) == t) {
            itor = rickers.erase(itor);
            return;
        }
    }
}

void 
RickerSys::isr(void)
{
    if (!rickers.empty()) {  
        for (list<Ricker *>::iterator itor = rickers.begin(); itor != rickers.end(); ++itor) {
            (*itor)->tick();
        }
    }
    
    LPC_RIT->RICTRL |= 0x1; /* Dismiss the IRQ. */    
}    

}; // namespace AjK ends.
