
/* Example using a Ricker to make a callback to a C++ object/method */

#include "mbed.h"
#include "Ricker.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

Ticker t1;
Ticker t2;
Ricker r3;
Ricker r4;

class Flipper {
protected:
    DigitalOut *_d;
public:
    Flipper(DigitalOut *d) { _d = d; }
    void flip(void) { *(_d) = !*(_d); }
};

int main() {

    led1 = 1;
    led3 = 1;
    
    Flipper f1(&led1);
    Flipper f2(&led2);
    Flipper f3(&led3);
    Flipper f4(&led4);
    
    t1.attach(&f1, &Flipper::flip, 0.25);
    t2.attach(&f2, &Flipper::flip, 0.25);
    r3.attach(&f3, &Flipper::flip, 0.25);
    r4.attach(&f4, &Flipper::flip, 0.25);
    
    while(1) { }
}
