
/* Example using a Ricker to make a callback to a C style function */

#include "mbed.h"
#include "Ricker.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

Ticker t1; // Standard Mbed Ticker
Ticker t2; // Standard Mbed Ticker
Ricker r3; // A Ricker
Ricker r4; // A Ricker

void cb1(void) { led1 = !led1; }
void cb2(void) { led2 = !led2; }
void cb3(void) { led3 = !led3; }
void cb4(void) { led4 = !led4; }

int main() {

    led1 = 1;
    led3 = 1;
    
    t1.attach(&cb1, 0.25);
    t2.attach(&cb2, 0.25);
    r3.attach(&cb3, 0.25);
    r4.attach(&cb4, 0.25);
    
    while(1) { }
}
