/****************************************************************************
 *    Copyright 2010 Andy Kirkham, Stellar Technologies Ltd
 *    
 *    This file is part of the Satellite Observers Workbench (SOWB).
 *
 *    SOWB is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    SOWB is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with SOWB.  If not, see <http://www.gnu.org/licenses/>.
 *
 *    $Id: main.cpp 5 2010-07-12 20:51:11Z ajk $
 *    
 ***************************************************************************/

typedef struct _max7456_custom_char {
    unsigned char         ascii;
    const unsigned char   *map;
} MAX7456_CUSTOM_CHAR;

/* Why doesn't the MAX7456 have a + symbol? wtf! */
const unsigned char ascii_4d[54] = {
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x00, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x00, 0x28, 0x00,
    0x4A, 0xAA, 0xA1,
    0x4A, 0xAA, 0xA1,
    0x00, 0x28, 0x00,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x00, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55    };

const unsigned char crosshair1_left[54] = {
    0x55, 0x55, 0x56, // 0
    0x55, 0x55, 0x56, // 1
    0x55, 0x55, 0x56, // 2
    0x55, 0x55, 0x56, // 3
    0x55, 0x55, 0x56, // 4
    0x55, 0x55, 0x56, // 5
    0x55, 0x55, 0x55, // 6
    0x55, 0x55, 0x55, // 7
    0x55, 0xAA, 0x95, // 8
    0x55, 0xAA, 0x95, // 9  - 8
    0x55, 0x55, 0x55, // 10 - 7
    0x55, 0x55, 0x55, // 11 - 6
    0x55, 0x55, 0x56, // 12 - 5
    0x55, 0x55, 0x56, // 13 - 4
    0x55, 0x55, 0x56, // 14 - 3
    0x55, 0x55, 0x56, // 15 - 2
    0x55, 0x55, 0x56, // 16 - 1
    0x55, 0x55, 0x56    };

const unsigned char crosshair1_right[54] = {
    0x95, 0x55, 0x55, // 0
    0x95, 0x55, 0x55, // 1
    0x95, 0x55, 0x55, // 2
    0x95, 0x55, 0x55, // 3
    0x95, 0x55, 0x55, // 4
    0x95, 0x55, 0x55, // 5
    0x55, 0x55, 0x55, // 6
    0x55, 0x55, 0x55, // 7
    0x56, 0xAA, 0x55, // 8
    0x56, 0xAA, 0x55, // 9  - 8
    0x55, 0x55, 0x55, // 10 - 7
    0x55, 0x55, 0x55, // 11 - 6
    0x95, 0x55, 0x55, // 12 - 5
    0x95, 0x55, 0x55, // 13 - 4
    0x95, 0x55, 0x55, // 14 - 3
    0x95, 0x55, 0x55, // 15 - 2
    0x95, 0x55, 0x55, // 16 - 1
    0x95, 0x55, 0x55    };
    
const unsigned char crosshair_centre[54] = {
    0x55, 0x28, 0x55,   // 0
    0x55, 0x28, 0x55,   // 1
    0x55, 0x28, 0x55,   // 2
    0x55, 0x28, 0x55,   // 3
    0x55, 0x28, 0x55,   // 4
    0x55, 0x00, 0x55,   // 5
    0x55, 0x55, 0x55,   // 6
    0x01, 0x55, 0x40,   // 7
    0xA1, 0x69, 0x4A,   // 8
    0xA1, 0x69, 0x4A,   // 9
    0x01, 0x55, 0x40,   // 10
    0x55, 0x55, 0x55,   // 11
    0x55, 0x00, 0x55,   // 12
    0x55, 0x28, 0x55,   // 13
    0x55, 0x28, 0x55,   // 14
    0x55, 0x28, 0x55,   // 15
    0x55, 0x28, 0x55,   // 16
    0x55, 0x28, 0x55    };
    

const unsigned char ascii_b0[54] = {
    0x55, 0x55, 0x55, // 0
    0x55, 0x55, 0x55, // 1
    0x50, 0x01, 0x55, // 2
    0x42, 0xA0, 0x55, // 3
    0x0A, 0xA8, 0x15, // 4
    0x28, 0x0A, 0x15, // 5
    0x28, 0x0A, 0x15, // 6
    0x28, 0x0A, 0x15,
    0x0A, 0xA8, 0x15,
    0x42, 0xA0, 0x55,
    0x50, 0x01, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55    };

const unsigned char ascii_b3[54] = {
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55    };

const unsigned char ascii_b4[54] = {
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x00, 0x28, 0x55,
    0xAA, 0xA8, 0x55,
    0xAA, 0xA8, 0x55,
    0x00, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55    };

const unsigned char ascii_bf[54] = {
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x00, 0x00, 0x55,
    0xAA, 0xA8, 0x55,
    0xAA, 0xA8, 0x55,
    0x00, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55    };

const unsigned char ascii_c0[54] = {
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x00,
    0x55, 0x2A, 0xAA,
    0x55, 0x2A, 0xAA,
    0x55, 0x00, 0x00,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55    };

const unsigned char ascii_c1[54] = {
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x00, 0x28, 0x00,
    0xAA, 0xAA, 0xAA,
    0xAA, 0xAA, 0xAA,
    0x00, 0x00, 0x00,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55    };

const unsigned char ascii_c2[54] = {
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x00, 0x00, 0x00,
    0xAA, 0xAA, 0xAA,
    0xAA, 0xAA, 0xAA,
    0x00, 0x28, 0x00,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55    };

const unsigned char ascii_c3[54] = {
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x00,
    0x55, 0x2A, 0xAA,
    0x55, 0x2A, 0xAA,
    0x55, 0x28, 0x00,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55    };

const unsigned char ascii_c4[54] = {
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x00, 0x00, 0x00,
    0xAA, 0xAA, 0xAA,
    0xAA, 0xAA, 0xAA,
    0x00, 0x00, 0x00,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55    };

const unsigned char ascii_c5[54] = {
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x00, 0x28, 0x00,
    0xAA, 0xAA, 0xAA,
    0xAA, 0xAA, 0xAA,
    0x00, 0x28, 0x00,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55    };

const unsigned char ascii_d9[54] = {
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x00, 0x28, 0x55,
    0xAA, 0xA8, 0x55,
    0xAA, 0xA8, 0x55,
    0x00, 0x00, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55    };

const unsigned char ascii_da[54] = {
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x55, 0x55,
    0x55, 0x00, 0x00,
    0x55, 0x2A, 0xAA,
    0x55, 0x2A, 0xAA,
    0x55, 0x28, 0x00,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55,
    0x55, 0x28, 0x55    };

/* For the curious, during testing I managed to screw up the
   characher at CM index2, ('2'). So I needed to reprogram
   index2 with the correct character, doh! Anyway, since I
   went to the trouble I'll leave it in the code. I managed
   to find a default CM map at:- 
        http://www.maxim-ic.com/tools/evkit/index.cfm?EVKit=558
   If you download this then be aware that the DEFAULTCM.MCM file
   defines each charmap as 64bytes, the 10 additional bytes need
   to be stripped off as "not used". */
#ifdef FIX_CM2_SCREW_UP
const unsigned char ascii_02[54] = {
    0x55, 0x55, 0x55, // 01010101 01010101 01010101
    0x55, 0x55, 0x55, // 01010101 01010101 01010101
    0x54, 0x00, 0x15, // 01010100 00000000 00010101
    0x52, 0xAA, 0x85, // 01010010 10101010 10000101
    0x4A, 0xAA, 0xA1, // 01001010 10101010 10100001
    0x2A, 0x80, 0xA8, // 00101010 10000000 10101000
    0x2A, 0x15, 0x28, // 00101010 00010101 00101000
    0x40, 0x55, 0x28, // 01000000 01010101 00101000
    0x55, 0x54, 0xA8, // 01010101 01010100 10101000
    0x55, 0x52, 0xA1, // 01010101 01010010 10100001
    0x55, 0x4A, 0x85, // 01010101 01001010 10000101
    0x55, 0x2A, 0x15, // 01010101 00101010 00010101
    0x54, 0xA8, 0x55, // 01010100 10101000 01010101
    0x52, 0xA1, 0x55, // 01010010 10100001 01010101
    0x4A, 0x80, 0x01, // 01001010 10000000 00000001
    0x2A, 0xAA, 0xA8, // 00101010 10101010 10101000
    0x2A, 0xAA, 0xA8, // 00101010 10101010 10101000
    0x40, 0x00, 0x01  // 01000000 00000000 00000001
};
#endif

/* Create an array of structures that link the data
   characters to ASCII characters. The last entry 
   must always be null so we can detect the end of 
   the array. */    
MAX7456_CUSTOM_CHAR custom_chars[] = {
    { 0xE0, crosshair1_left },
    { 0xE1, crosshair1_right },
    { 0xE2, crosshair_centre },
    { 0x4D, ascii_4d },
    { 0xB0, ascii_b0 },
    { 0xB3, ascii_b3 },
    { 0xB4, ascii_b4 },
    { 0xBF, ascii_bf },
    { 0xC0, ascii_c0 },
    { 0xC1, ascii_c1 },
    { 0xC2, ascii_c2 },
    { 0xC3, ascii_c3 },
    { 0xC4, ascii_c4 },
    { 0xC5, ascii_c5 },
    { 0xD9, ascii_d9 },
    { 0xDA, ascii_da },
#ifdef FIX_CM2_SCREW_UP    
    { 0x02, ascii_02 },
#endif    
    { 0x00, 0 }
};


