#ifdef COMPILE_EXAMPLE_CODE_MODOSD7456

#include "mbed.h"
#include "OSD7456.h"

DigitalOut led1(LED1);

OSD7456 *osd;

int main() {
    
    osd = new OSD7456(MAX7456_MOSI, MAX7456_MISO, MAX7456_SCLK, MAX7456_CS, MAX7456_RST, MAX7456_VSYNC);
    
    // Set the character "local background" to 42%
    osd->max7456->backGround(MAX7456::Percent_42);
    
    // Set the blink rate to 133ms with a duty cycle of 3:1
    osd->max7456->blinkRate(MAX7456::ms_133, MAX7456::BT3_BT);
    
    osd->print(1, "        Hello World");
    osd->print(7, 4,  "Positioned text");
    osd->print(7, 6,  "Positioned text", MAX7456::LocalBG);
    osd->print(3, 8,  "Positioned text blinks", MAX7456::Blink | MAX7456::LocalBG);
    osd->print(4, 10, " Blinks and inverse ", MAX7456::Blink | MAX7456::LocalBG | MAX7456::Inverse);
    
    while(1) {
        led1 = 1;
        wait(0.5);        
        led1 = 0;
        wait(0.5);    
    }
}

#endif
