/****************************************************************************
 * Product: LIB17 Open Source Library
 *
 *                    Steller Technologies Limited
 *                    ----------------------------
 *
 * Copyright (C) 2002-2011 Steller Technologies Limited. All rights reserved.
 *
 * This software may be distributed and modified under the terms of the GNU
 * General Public License version 2 (GPL) as published by the Free Software
 * Foundation and appearing in the file GPL.TXT included in the packaging of
 * this file. Please note that GPL Section 2[b] requires that all works based
 * on this software must also be made publicly available under the terms of
 * the GPL ("Copyleft").
 *
 * Alternatively, this software may be distributed and modified under the
 * terms of Steller Technologies Limited commercial licenses, which expressly
 * supersede the GPL and are specifically designed for licensees interested in
 * retaining the proprietary status of their code.
 *
 ***************************************************************************/

#ifndef AJK_Lib17_Tim_H
#define AJK_Lib17_Tim_H

#include "LPC17xx.h"
#include <stdint.h>

#include "Lib17_Callback.h"

namespace AjK {

// Forward reference.
class Timer17;

class Lib17_Tim {
protected:
    LPC_TIM_TypeDef *_base;
    
    Timer17 *_list_head;
    
    void init(void) {
    
    }
    
public:
    
    Lib17_Tim(LPC_TIM_TypeDef *base) {
        _base = base;
        init();
    }
    
};


class Timer17 {
protected:
    Lib17_Callback  _callback;
    uint32_t        _counter;
    uint32_t        _reload;
    Timer17        *_next;
    
public:
    friend class Lib17_Tim;
    
    void attach(uint32_t (*function)(uint32_t), uint32_t counter, uint32_t reload) {
        _callback.attach(function);
        setCounter(counter);
        setReload(reload);
        _system->attach(this);
    }
    
    void setCounter(uint32_t counter) { _counter = counter; }
    void setReload(uint32_t reload) { _reload = reload; }            
};


}; // namespace AjK ends.

#endif