/*
    Copyright (c) 2010 Andy Kirkham
 
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:
 
    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.
 
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.
*/


#include "mbed.h"
#include "LLDP.h"

const char LLDPinfo1[] = "MBED";
const char LLDPinfo2[] = "A rapid prototyping system for the LPC17xx embedded microcontroller";
const char LLDPinfo3[] = "\x00\x80\x00\x80";

LLDP::LLDP() : Ethernet() 
{
    int totalLength = 0;
    address(macAddress);
    
    memset(buffer, 0xFF, sizeof(buffer));
    
    // Default to 4:MACAddress 
    _chassis.setSubtype(4);
    _chassis.setPayload(macAddress, 6);
    
    // Default to 4:MACAddress 
    _port.setSubtype(3);
    _port.setPayload(macAddress, 6);
    
    //_mbed.setOUI(macAddress);
    //_mbed.setSubtype(1);
    //_mbed.setPayload((char *)LLDPinfo, strlen(LLDPinfo));
    _systemName.base.header.setType(5);
    _systemName.setPayload((char *)LLDPinfo1, strlen(LLDPinfo1));
    
    _systemDesc.base.header.setType(6);
    _systemDesc.setPayload((char *)LLDPinfo2, strlen(LLDPinfo2));
    
    _systemCap.base.header.setType(7);
    _systemCap.setPayload((char *)LLDPinfo3, 4);
    
    totalLength += _chassis.copy(buffer + totalLength);
    totalLength += _port.copy(buffer + totalLength);
    totalLength += _ttl.copy(buffer + totalLength);
    //totalLength += _mbed.copy(buffer + totalLength);
    totalLength += _systemName.copy(buffer + totalLength);
    totalLength += _systemDesc.copy(buffer + totalLength);
    totalLength += _systemCap.copy(buffer + totalLength);
    totalLength += _end.copy(buffer + totalLength);
    buflen = totalLength;   
}

void
LLDP::broadcast(void)
{
    char e[6 + 6 + 2];
    
    e[0] = 0x01; e[1] = 0x80; e[2] = 0xc2; e[3] = 0x00; e[4] = 0x00; e[5] = 0x0e;
    e[6] = macAddress[0];
    e[7] = macAddress[1];
    e[8] = macAddress[2];
    e[9] = macAddress[3];
    e[10] = macAddress[4];
    e[11] = macAddress[5];
    e[12] = 0x88;
    e[13] = 0xCC;
    
    write(e, 6 + 6 + 2);
    write(buffer, buflen);
    send();    
}
