/*
    Copyright (c) 2010 Andy Kirkham
 
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:
 
    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.
 
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.
*/

#ifndef LLPDP_H
#define LLPDP_H

#ifndef MBED_H
#include "mbed.h"
#endif

#include "tlv.h"
#include "tlv_chassis.h"
#include "tlv_port.h"
#include "tlv_ttl.h"
#include "tlv_basic.h"
#include "tlv_custom.h"

class LLDP : public Ethernet
{
public:

    LLDP();
    virtual ~LLDP() {}
    
    void broadcast(void);    
    
    // Properties.
    tlv_chassis _chassis;        
    tlv_port    _port;
    tlv_ttl     _ttl;
    tlv_custom  _mbed;
    tlv_basic   _systemName;
    tlv_basic   _systemDesc;
    tlv_basic   _systemCap;
    tlv_header  _end;
    
    char macAddress[6];
    char buffer[0x600];
    int  buflen;
    
        
};

#endif
