/*
    Copyright (c) 2010 Andy Kirkham
 
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:
 
    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.
 
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.
*/

#ifndef TLV_H
#define TLV_H

#ifndef MBED_H
#include "mbed.h"
#endif

class tlv_header {
public:
    uint16_t    typeLength;
    tlv_header() { typeLength = 0; }
    int copy (char *s);
    void setType(int type) { typeLength |= ((type & 0x7F) << 9); }
    int  getType(void) { return (typeLength >> 9) & 0x7F; }
    void setLength(int len) { typeLength |= (len & 0x1FF); }
    int  getLength(void) { return typeLength & 0x1FF; }
    //void setType(int type) { typeLength |= (type & 0x7F); }
    //int  getType(void) { return typeLength & 0x7F; }
    //void setLength(int len) { typeLength |= ((len & 0x1FF) << 7); }
    //int  getLength(void) { return (typeLength >> 7) & 0x1FF; }
};

class tlv_payload {
public:
    char   *pointer;
    int     length;
    tlv_payload() { length = 0; pointer = NULL; }
};

#endif
