#ifdef COMPILE_LLDP_TEXT

#include "mbed.h"
#include "LLDP.h"

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);
LLDP lldp;

int main() {
    char test[256];
    int j, k;
      
    pc.baud(115200);

    pc.printf("Chassis type = %d\r\n", lldp._chassis.base.header.getType());
    pc.printf("Chassis len  = %d\r\n", lldp._chassis.base.header.getLength());
    for (j = 0, k = lldp._chassis.copy(test); j < k; j++) pc.printf("%02X ", test[j]);
    pc.printf("\r\n");
    
    pc.printf("Port type = %d\r\n", lldp._port.base.header.getType());
    pc.printf("Port len  = %d\r\n", lldp._port.base.header.getLength());
    for (j = 0, k = lldp._port.copy(test); j < k; j++) pc.printf("%02X ", test[j]);
    pc.printf("\r\n");
    

    pc.printf("Size is %d\r\n", lldp.buflen);
    for (int i = 0; i < lldp.buflen; i++) {
        pc.printf("%02X ", lldp.buffer[i]);
    }
    pc.printf("\r\nDone.\r\n");
    
    while(1) {
        myled = 1;
        wait(0.5);
        myled = 0;
        wait(0.5);
        lldp.broadcast();
    }
}

#endif
