
#include "mbed.h"
#include "iomacros.h"

// Works with 10 (ie CLK cycle time 20us)
// but fails with 5 (10us). No where even 
// close to 6.5MHz !!
#define DELAY 10

#define SYNC_1  p23_SET
#define SYNC_0  p23_CLR
#define CLK_1   p22_SET
#define CLK_0   p22_CLR
#define DATA_1  p21_SET
#define DATA_0  p21_CLR

void tx(Serial *pc, DigitalOut *led1) {
    uint16_t counter = 0xAAAA, mask;
    
    pc->printf("Starting MBED as the sender...\n");
    
    p21_AS_OUTPUT;  // SERDATA
    p22_AS_OUTPUT;  // CLK
    p23_AS_OUTPUT;  // SYNC

    p21_CLR;
    p22_CLR;
    p23_SET;

    while(1) {
        mask = 0x8000;
        for (int i = 0; i < 16; i++) {
            
            if (i == 0) {
                SYNC_1;                
            }
            else {
                SYNC_0;                
            }
            
            if ((counter & mask) != 0) DATA_1;
            else                       DATA_0;
            
            CLK_1;
            wait_us(DELAY);
            
            CLK_0;            
            wait_us(DELAY);
            
            mask = mask >> 1;
        }
    
        // The above loop recreates Michele's waveform as shown on
        // http://mbed.org/forum/helloworld/topic/1674
        
        // However, to coax the receiving SSP on the other Mbed
        // the following extra clk is needed. Even then the 16bit
        // value read isn't 0xAAAA but 0x5554 as the first bit is sent
        // while SYNC is asserted. Thus the "other end" doesn't see bit0
        // and misses the last bit.
        
        //CLK_1; wait_us(DELAY); CLK_0; wait_us(DELAY);
        
        //counter++;
    }    
}
