
#include "mbed.h"
#include "iomacros.h"

DigitalOut led1(LED1);
Serial pc(USBTX, USBRX);

// The two main functions, call one or the other
// depending on P20, one Mbed or the other.
void tx(Serial *, DigitalOut *);
void rx(Serial *, DigitalOut *);

int main() {

    p20_AS_INPUT;
    p20_MODE(PIN_PULLUP);
    
    pc.baud(115200);
    
    if (p20_IS_SET) tx(&pc, &led1); // This is the sending Mbed that creates the waveforms
    else            rx(&pc, &led1); // This is the receiving Mbed that tries to read it.
    
    // Note, I used two Mbeds. I could just use one but I didn't want the
    // software creating the waveforms to steal CPU time. I wanted the receiver
    // to have all available CPU time it needed. End result, no where enough
    // with a software soluttion and the SSP failed totally by missing the first bit.
    
    // With the software solution I did manage to read the data but only to about
    // 500kHz. The Mbed libs are known to be slow so I could have tried using direct
    // peripheral usage. But I know from experience that even doing that I would prob
    // get upto about maybe 1.5MHz. No where near the 6.5MHz needed to read the 
    // AD9951 DSP serial output. Shame on Maxim for having a, err, dumb ass serial
    // protocol!

    
}
