
#include "mbed.h"

bool doPrint;
InterruptIn ad9951_clk(p13);
InterruptIn ad9951_sync(p14);
DigitalIn   ad9951_data(p11);

int bitCount, bitCountR;
uint16_t dsp_value, dsp_value_shift;

void ad9951_sync_rise(void) {
    dsp_value = dsp_value_shift;
    dsp_value_shift = 0;
    bitCountR = bitCount;
    bitCount = 0;
    doPrint = true;
}

void ad9951_clk_fall(void) {
    bitCount++;
    dsp_value_shift = dsp_value_shift << 1;
    dsp_value_shift |= ad9951_data == 1 ? 1 : 0;    
}

void rx(Serial *pc, DigitalOut *led1) {
    doPrint = false;
    dsp_value = dsp_value_shift = 0;
    bitCount = 0;
    
    pc->printf("Starting MBED as the receiver...\n");
    
    ad9951_sync.rise(&ad9951_sync_rise);
    ad9951_clk.fall(&ad9951_clk_fall);
    
    while(1) {
        if (doPrint) {
            
            pc->printf("Got %04x from %d\n", dsp_value, bitCountR);
            doPrint = false;
        }
    }
}

#ifdef NO_COMPILE

#include "AD9951DSPSERIAL.h"

Ticker led1Flasher;
DigitalOut *pLed1;
AD9951DSPSERIAL *myDevice;

bool irqCalled;
uint16_t dsp_value;

void flashLed1(void) {
    pLed1->write( !pLed1->read() );
}

void dspReadCallback(uint16_t value) {
    if (!irqCalled) {
        dsp_value = value;
        irqCalled = true;
    }
}

void rx(Serial *pc, DigitalOut *led1) {
    pLed1 = led1;
    
    irqCalled = false;
    
    pc->printf("Starting MBED as the receiver...\n");
    
    myDevice = new AD9951DSPSERIAL(p11, p12, p13, p14);
    
    led1Flasher.attach(&flashLed1, 0.1);
    
    myDevice->attach_dspread(&dspReadCallback);
    
    while(1) {
        if (irqCalled) {
            pc->printf("Got %04x\n", dsp_value);
            irqCalled = false;
        }
    }
}

#endif
