/*
    Copyright (c) 2011 Andy Kirkham
 
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:
 
    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.
 
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.
*/

#ifndef AJK_AD9951DSPSERIAL_H
#define AJK_AD9951DSPSERIAL_H

#include "mbed.h"

namespace AjK {

class AD9951DSPSERIALDummy;

class AD9951DSPSERIAL {

protected:

    LPC_SSP_TypeDef *ssp;
    
    // C callback function pointer for to pass read data to.
    void (*_dspread_function)(uint16_t); 
    
    // C++ style callback method pointer for to pass read data to.
    AD9951DSPSERIALDummy  *_dspread_obj;
    void (AD9951DSPSERIALDummy::*_dspread_method)(uint16_t);
    
    void init(void);
    
public:

    AD9951DSPSERIAL();
    
    AD9951DSPSERIAL(PinName mosi, PinName miso, PinName sclk, PinName ssel);
    
    void ssp_isr(void);
    
    void attach_dspread(void (*function)(uint16_t) = 0) { _dspread_function = function; }
    
    template<class T> 
    void attach_dspread(T* item, void (T::*method)(uint16_t)) { 
        _dspread_obj    = (AD9951DSPSERIALDummy *)item; 
        _dspread_method = (void (AD9951DSPSERIALDummy::*)(uint16_t))method; 
    }
};

}; // namespace AjK ends

using namespace AjK;

#endif
