/************************Library****************************/
#include "mbed.h"                   //library mbed
#include "C12832.h"                 //menu Shield
#include <stdlib.h>                 //Use rand
#include "Speaker.h"                //Speaker
#include <string>
/***********************Using Nucleo pin notation*********/
C12832 lcd(D11, D13, D12, D7, D10);
/***********************Leds*******************************/
DigitalOut red_led(D5);
DigitalOut blue_led(D8);
DigitalOut green_led(D9);
/***********************Speakers***************************/
Speaker mySpeaker(D6);
/************************Ticker****************************/
Ticker move;
/************************Green Joystick**************************/
AnalogIn joyStickDown(PC_0);
AnalogIn joyStickLeft(PC_1);
AnalogIn joyStickUp(PB_0);
AnalogIn joyStickRight(PA_4);
/************************Small Joystick**************************/
DigitalIn fire(D4);
/***********************Variables****************************/
int score = 0;
float tikk=0.1;
enum directions{ up, down, left, right, null};
enum partie{ start, stop, run, pause};
directions moveWhere;
partie game;
int allPosition[126][30]; // 0 : empty; 1 : mouse; 2 : wall;
/***********************Classes*****************************/
struct point{
    int x;
    int y;
};
struct point head;
struct point mouse;
struct point wall;
point* corp = new point[score+5];
/***********************Fonctions****************************/
// Init mouse
void SetMouse(){
  mouse.x=rand()%126+1;
  mouse.y=rand()%30+1;
  allPosition[mouse.x][mouse.y]=1;
  if(allPosition[mouse.x][mouse.y] == 2){
    SetMouse();
  }
}
// Init wall
void SetWall(){
    wall.x=rand()%126+1;//rand()%126+1;
    wall.y=rand()%30+1;//rand()%30+1;
    allPosition[wall.x][wall.y]=2;
    allPosition[wall.x+1][wall.y]=2;
    if(allPosition[wall.x][wall.y] == 1){
      SetWall();
    }
}

// Change direction avoiding going back in the same way
void Up_Direction(){
    if(moveWhere!=down){
        moveWhere=up;
    }
}
void Down_Direction(){
    if(moveWhere!=up){
        moveWhere=down;
    }
}
void Left_Direction(){
    if(moveWhere!=right){
        moveWhere=left;
    }
}
void Right_Direction(){
    if(moveWhere!=left){
        moveWhere=right;
    }
}

// Put the game in hold
void Push_Touch(){
    wait(0.5);
    if(game==run){
        moveWhere=null;
        game=pause;
    }else if(game==pause){
        game=run;
    }else if(game == stop){
        for(int i=0;i<=4;i++){
            corp[i].x=(head.x)-(i+1);
            corp[i].y=15;
        }
        moveWhere=null;
        game=run;
    }
}

// Move the snake
void MoveSnake(){
    if(game==run){
        if(moveWhere!=null){
            for(int i=(score+4);i>=1;i--){
                corp[i]=corp[i-1];
            }
            corp[0]=head;
        }
        switch(moveWhere){
            case up:
                head.y-=1;
                break;
            case down:
                head.y+=1;
                break;
            case left:
                head.x-=1;
                break;
            case right:
                head.x+=1;
                break;
        }
// Crashed
        if(head.x==127 ||head.x==0 ||head.y==0 ||head.y==31 ){
            lcd.cls();
            lcd.locate(33,5);
            lcd.printf("Game Over!");
            lcd.locate(33,15);
            lcd.printf("Your score is : %d",score);
            moveWhere=null;
            head.x=15;
            head.y=15;
            game=stop;
            score=0;
            tikk=0.1;
        }else if((head.x==mouse.x)&&(head.y==mouse.y)){
          //Eat the mouse
            score+=1;
            SetMouse();
            tikk=tikk-0.01;
            return move.attach(&MoveSnake, tikk);
        }else{
            lcd.cls();
            lcd.pixel(head.x,head.y,1);
            lcd.copy_to_lcd();
            for(int k=0;k<=(score+4);k++){
                lcd.pixel(corp[k].x,corp[k].y,1);
            }
            lcd.copy_to_lcd();
            lcd.pixel(mouse.x,mouse.y,1);
            lcd.copy_to_lcd();
            lcd.rect(0,0, 127, 31, 1);
            lcd.copy_to_lcd();
        }
// Game Over
        for(int a=0;a<=(score+4);a++){
            if(corp[a].x==head.x && corp[a].y==head.y){
                lcd.cls();
                lcd.locate(33,5);
                lcd.printf("Game Over!");
                lcd.locate(35,15);
                lcd.printf("Votre score : %d",score);
                moveWhere=null;
                head.x=15;
                head.y=15;
                game=stop;
                tikk=0.1;
                score=0;
            }
        }
    }
    //Hold the game
    else if(game==pause){
        lcd.cls();
        lcd.locate(33,15);
        lcd.printf("Pause");
    }
}

// Move the snake Hardcore
void MoveSnakeHardcore(){
    if(game==run){
        if(moveWhere!=null){
            for(int i=(score+4);i>=1;i--){
                corp[i]=corp[i-1];
            }
            corp[0]=head;
        }
        switch(moveWhere){
            case up:
                head.y-=1;
                break;
            case down:
                head.y+=1;
                break;
            case left:
                head.x-=1;
                break;
            case right:
                head.x+=1;
                break;
        }

        if(head.x==127 ||head.x==0 ||head.y==0 ||head.y==31 ){
            lcd.cls();
            lcd.locate(33,5);
            lcd.printf("Game Over!");
            lcd.locate(33,15);
            lcd.printf("Your score is : %d",score);
            moveWhere=null;
            head.x=15;
            head.y=15;
            game=stop;
            score=0;
            tikk=0.1;
        }else if(allPosition[head.x][head.y]==2){
            lcd.cls();
            lcd.locate(33,5);
            lcd.printf("Game Over!");
            lcd.locate(33,15);
            lcd.printf("Your score is : %d",score);
            moveWhere=null;
            head.x=15;
            head.y=15;
            game=stop;
            score=0;
            tikk=0.1;
        }else if(allPosition[head.x][head.y]==1){
            score+=1;
            SetMouse();
            SetWall();
            tikk=tikk-0.01;
            return move.attach(&MoveSnakeHardcore, tikk);
        }else{
            lcd.cls();
            lcd.pixel(head.x,head.y,1);
            lcd.copy_to_lcd();
            for(int k=0;k<=(score+4);k++){
                lcd.pixel(corp[k].x,corp[k].y,1);
        }
        lcd.copy_to_lcd();
        lcd.pixel(mouse.x,mouse.y,1);
        lcd.copy_to_lcd();
        lcd.pixel(wall.x,wall.y,4);
        lcd.copy_to_lcd();
        lcd.pixel(wall.x+1,wall.y,4);
        lcd.copy_to_lcd();
        lcd.rect(0,0, 127, 31, 1);
        lcd.copy_to_lcd();
        }

        for(int a=0;a<=(score+4);a++){
            if(corp[a].x==head.x && corp[a].y==head.y){
                lcd.cls();
                lcd.locate(33,5);
                lcd.printf("Game Over!");
                lcd.locate(35,15);
                lcd.printf("Votre score : %d",score);
                moveWhere=null;
                head.x=15;
                head.y=15;
                game=stop;
                tikk=0.1;
                score=0;
            }
        }
    }
    else if(game==pause){
        lcd.cls();
        lcd.locate(33,15);
        lcd.printf("Pause");
    }
}


int main() {
    int m=0;
    int p=0;

    char* tab_menu[3];
        tab_menu[0]="Snake";
        tab_menu[1]="Snake Hardcore";
        tab_menu[2]="???";

    bool isStarted=false;

    // Menu
    while(isStarted==false){
        int j=0;
        int light;

        for(j=10;j>0;j--){
            lcd.locate(0,j);
            lcd.printf("I");
            mySpeaker.PlayNote(45*j,0.1,0.1);

            lcd.locate(33,5);
            lcd.printf("Menu Projet!");

            light =rand()%3;
            if(light==0){
                wait(0.1);
                red_led=1;
            }else if(light==1){
                wait(0.1);
                blue_led=1;
            }else{
                wait(0.1);
                green_led=1;
            }
            lcd.cls();
        }
        lcd.locate(33,5);
        lcd.printf("Choisissez un jeu");

        while(1) {
            lcd.locate(0,15);
            lcd.printf(tab_menu[m]);
            if(joyStickUp){
                m=(m-1+3)%3;
                lcd.cls();
                lcd.locate(0,2);
                lcd.printf("Choisissez un jeu");
                lcd.locate(0,15);
                lcd.printf(tab_menu[m]);
                wait(0.5);
            }
            else if(joyStickDown){
                m=(m+1+3)%3;
                lcd.cls();
                lcd.locate(0,2);
                lcd.printf("Choisissez un jeu");
                lcd.locate(0,15);
                lcd.printf(tab_menu[m]);
                wait(0.5);
            }else if(fire){
                p=m;
                isStarted=true;
                break;

            }
        }
    }

    // Snake game
    while(isStarted==true && p==0){
        int j=0;
        int light;
        lcd.cls();

        for(j=10;j>0;j--){
            lcd.locate(0,j);
            lcd.printf("I");
            mySpeaker.PlayNote(100*j,0.1,0.1);

            lcd.locate(33,5);
            lcd.printf("Snake Game");
            mySpeaker.PlayNote(40.0/j,0.1,0.5);
            light =rand()%3;
            if(light==0){
                wait(0.1);
                red_led=1;
            }else if(light==1){
                wait(0.1);
                blue_led=1;
            }else{
                wait(0.1);
                green_led=1;
            }
            lcd.cls();
        }
        lcd.locate(0,2);
        for(int f=3;f>=0;f--){
            lcd.locate(0,2);
            lcd.printf("Snake begin in : %d",f);
            wait(1.0);
            lcd.cls();
        }

        //Snake start
        game=run;
        lcd.rect(0,0,127,31,1);
        lcd.copy_to_lcd();
        moveWhere=null;
        moveWhere=right;
        head.x=15;
        head.y=15;
        for (int i=0;i<=4;i++){
            corp[i].x=(head.x)-(i+1);
            corp[i].y=15;
        }
        SetMouse();
        move.attach(&MoveSnake, 0.1);
        while (1){
            if(joyStickUp)
                Up_Direction();
            else if(joyStickDown)
                Down_Direction();
            else if(joyStickLeft)
                Left_Direction();
            else if (joyStickRight)
                Right_Direction();
            else if (fire)
                Push_Touch();
        }
    }

    //Snake Hardcore
    while(isStarted==true && p==1){
        int j=0;
        int light;
        lcd.cls();

        for(j=10;j>0;j--){
            lcd.locate(0,j);
            lcd.printf("I");
            mySpeaker.PlayNote(35*j,0.1,0.1);

            lcd.locate(33,5);
            lcd.printf("Snake Hardcore Game");
            mySpeaker.PlayNote(10.0/j,0.1,0.5);
            light =rand()%3;
            if(light==0){
                wait(0.1);
                red_led=1;
            }else if(light==1){
                wait(0.1);
                blue_led=1;
            }else{
                wait(0.1);
                green_led=1;
            }
            lcd.cls();
        }
        lcd.locate(0,2);
        for(int f=3;f>=0;f--){
            lcd.locate(0,2);
            lcd.printf("Snake Hardcore begin in : %d",f);
            wait(1.0);
            lcd.cls();
        }

        //Snake Hardcore start
        game=run;
        lcd.rect(0,0,127,31,1);
        lcd.copy_to_lcd();
        moveWhere=null;
        moveWhere=right;
        head.x=15;
        head.y=15;
        for (int i=0;i<=4;i++){
            corp[i].x=(head.x)-(i+1);
            corp[i].y=15;
        }
        SetMouse();
        SetWall();
        move.attach(&MoveSnakeHardcore, 0.1);
        while (1){
            if(joyStickUp)
                Up_Direction();
            else if(joyStickDown)
                Down_Direction();
            else if(joyStickLeft)
                Left_Direction();
            else if (joyStickRight)
                Right_Direction();
            else if (fire)
                Push_Touch();
        }
    }
}
