#ifndef LSM303DLHC_REG_H
#define LSM303DLHC_REG_H

// ACC SAD
#define ACC_ADDRESS       0x32
// ACC CTRL SUB
#define CTRL_REG1_A       0x20 //RW ODR(4) LPen Zen Yen Xen
#define CTRL_REG2_A       0x21 //RW HPM(2) HPCF(2) FDS HPCLICK HPIS2 HPIS1
#define CTRL_REG3_A       0x22 //RW I1_CLICK I1_AOI1 I1_AOI2 I1_DRDY1 I1_DRDY2 I1_WTM I1_OVERRUN -
#define CTRL_REG4_A       0x23 //RW BDU BLE FS1 FS0 HR 0(2) SIM
#define CTRL_REG5_A       0x24 //RW BOOT FIFO_EN - - LIR_INT1 D4D_INT1 LIR_INT2 D4D_INT2
#define CTRL_REG6_A       0x25 //RW I2_CLICKen I2_INT1 I2_INT2 BOOT_I1 P2_ACT - H_LACTIVE -
#define REFERENCE_A       0x26 //RW Ref7 Ref6 Ref5 Ref4 Ref3 Ref2 Ref1 Ref0
#define STATUS_REG_A      0x27 //R  ZYXOR ZOR YOR XOR ZYXDA ZDA YDA XDA
// ACC OUT SUB
#define OUT_X_L_A         0x28 //R MSB(8)
#define OUT_X_H_A         0x29 //R LSB(4) 0(4)
#define OUT_Y_L_A         0x2A //R ditto
#define OUT_Y_H_A         0x2B //R ditto
#define OUT_Z_L_A         0x2C //R ditto
#define OUT_Z_H_A         0x2D //R ditto
// ACC INT SUB
#define INT1_CFG_A        0x30 
#define INT1_SRC_A        0x31
#define INT1_THS_A        0x32
#define INT1_DURATION_A   0x33
#define INT2_CFG_A        0x34
#define INT2_SRC_A        0x35
#define INT2_THS_A        0x36
#define INT2_DURATION_A   0x37
// ACC CLICK SUB
#define CLICK_CFG_A       0x38 
#define CLICK_SRC_A       0x39 
#define CLICK_THS_A       0x3A 
#define TIME_LIMIT_A      0x3B 
#define TIME_LATENCY_A    0x3C 
#define TIME_WINDOW_A     0x3D 

// MAG SAD
#define MAG_ADDRESS       0x3C 
// MAG CTRL SUB
#define CRA_REG_M         0x00 //RW TEMP_EN 0(2) DR(3) 0(2)
#define CRB_REG_M         0x01 //RW GN(3) 0(5)
#define MR_REG_M          0x02 //RW 0(6) MD(2)
// MAG OUT SUB
#define OUT_X_H_M         0x03 //R LSB(8)
#define OUT_X_L_M         0x04 //R 0(4) MSB(4)
#define OUT_Z_H_M         0x05 //R ditto
#define OUT_Z_L_M         0x06 //R ditto
#define OUT_Y_H_M         0x07 //R ditto
#define OUT_Y_L_M         0x08 //R ditto
#define SR_REG_M          0x09 //R -(6) LOCK DRDY
#define IRA_REG_M         0x0A //R
#define IRB_REG_M         0x0B //R
#define IRC_REG_M         0x0C //R
// Temprature OUT SUB
#define TEMP_OUT_H_M      0x31 //R MSB(8)
#define TEMP_OUT_L_M      0x32 //R LSB(4) 0(4)

#endif