#include "mbed.h"
#include "LSM303DLHC.h"

LSM303DLHC sensor(p9,p10);
Serial pc(USBTX,USBRX);
Ticker ticker;

float acc[3] = { 0 };
float mag[3] = { 0 };
float tmp[1] = { 0 };

void CallBack();

int main(){
    pc.baud(921600);
    
    // example setup
    // refer to LSM303DLHC.h for more overloaded details for ACtrl() MCtrl() TCtrl()   
    sensor.MCtrl(LSM303DLHC::GN1);          // set mag range +/-1.3Gausee
    sensor.MCtrl(LSM303DLHC::MDR3);          // set mag date rate 7.5Hz
    sensor.ACtrl(LSM303DLHC::G8);           // set acc range +/-8g
    sensor.ACtrl(LSM303DLHC::ADR2);         // set acc date rate 10Hz
    sensor.ACtrl(LSM303DLHC::HPF_OFF);      // disable internal acc HPF

    float acc_offset[3] = { 6.5, 5, 12.5 };  // acc offset
    float acc_scale[3] = { 3.9, 4, 4 };      // acc scale
    sensor.ACal(acc_offset,acc_scale);    // set acc calibration
    
    ticker.attach(&CallBack, 0.2);  // read and refresh disp with 200ms interval   
 
    while (1) 
        wait_us(1);
}

void CallBack(){
    sensor.GetAcc(acc);
    sensor.GetMag(mag);
    sensor.GetTemp(tmp);

    pc.printf("A %5f %5f %5f\n\r", acc[0], acc[1], acc[2]);
    pc.printf("M %5f %5f %5f\n\r", mag[0], mag[1], mag[2]);
    pc.printf("T %5f\n\r", tmp[0]);  
}
    