#include "Blocks.h"

Blocks::Blocks()
{

}

Blocks::~Blocks()
{
    
}

//Frame Sprite.
int Frame[11][1] = {
    {0},
    {0},
    {1},
    {1},
    {1},
    {1},
    {1},
    {1},
    {1},
    {0},
    {0},
    };
int One[11][15] = {
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,1,1,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,1,1,1,0,0,0,0,0,0},
    {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    };
int Two[11][15] = {
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,0,0,0,0,0,1,1,1,0,0,0,0,0,0},
    {0,0,0,0,0,1,0,0,0,1,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,1,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,1,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,1,1,1,1,1,0,0,0,0,0},
    {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    };
int Three[11][15] = {
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,0,0,0,0,1,1,1,1,1,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,1,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,1,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0},
    {0,0,0,0,0,1,0,0,0,1,0,0,0,0,0},
    {0,0,0,0,0,0,1,1,1,0,0,0,0,0,0},
    {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    };
int Four[11][15] = {
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,0,0,0,0,0,0,0,1,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,1,1,0,0,0,0,0,0},
    {0,0,0,0,0,0,1,0,1,0,0,0,0,0,0},
    {0,0,0,0,0,1,0,0,1,0,0,0,0,0,0},
    {0,0,0,0,0,1,1,1,1,1,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,1,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,1,0,0,0,0,0,0},
    {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    };
int Five[11][15] = {
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,0,0,0,0,1,1,1,1,1,0,0,0,0,0},
    {0,0,0,0,0,1,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,1,1,1,1,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0},
    {0,0,0,0,0,1,0,0,0,1,0,0,0,0,0},
    {0,0,0,0,0,0,1,1,1,0,0,0,0,0,0},
    {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    };
int Six[11][15] = {
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,0,0,0,0,0,0,1,1,1,0,0,0,0,0},
    {0,0,0,0,0,0,1,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,1,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,1,1,1,1,0,0,0,0,0,0},
    {0,0,0,0,0,1,0,0,0,1,0,0,0,0,0},
    {0,0,0,0,0,1,0,0,0,1,0,0,0,0,0},
    {0,0,0,0,0,0,1,1,1,0,0,0,0,0,0},
    {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    };
int Seven[11][15] = {
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,0,0,0,0,1,1,1,1,1,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,1,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,1,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,1,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,1,0,0,0,0,0,0,0,0},
    {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    };
int Eight[11][15] = {
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,0,0,0,0,0,1,1,1,0,0,0,0,0,0},
    {0,0,0,0,0,1,0,0,0,1,0,0,0,0,0},
    {0,0,0,0,0,1,0,0,0,1,0,0,0,0,0},
    {0,0,0,0,0,0,1,1,1,0,0,0,0,0,0},
    {0,0,0,0,0,1,0,0,0,1,0,0,0,0,0},
    {0,0,0,0,0,1,0,0,0,1,0,0,0,0,0},
    {0,0,0,0,0,0,1,1,1,0,0,0,0,0,0},
    {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    };
int Nine[11][15] = {
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,0,0,0,0,0,1,1,1,0,0,0,0,0,0},
    {0,0,0,0,0,1,0,0,0,1,0,0,0,0,0},
    {0,0,0,0,0,1,0,0,0,1,0,0,0,0,0},
    {0,0,0,0,0,0,1,1,1,1,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,1,0,0,0,0,0,0},
    {0,0,0,0,0,0,1,1,0,0,0,0,0,0,0},
    {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    };
int Ten[11][15] = {
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,0,0,0,1,0,0,0,1,1,1,0,0,0,0},
    {0,0,0,1,1,0,0,1,0,0,0,1,0,0,0},
    {0,0,0,0,1,0,0,1,0,0,1,1,0,0,0},
    {0,0,0,0,1,0,0,1,0,1,0,1,0,0,0},
    {0,0,0,0,1,0,0,1,1,0,0,1,0,0,0},
    {0,0,0,0,1,0,0,1,0,0,0,1,0,0,0},
    {0,0,0,1,1,1,0,0,1,1,1,0,0,0,0},
    {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    };
int Eleven[11][15] = {
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,0,0,0,0,1,0,0,0,0,1,0,0,0,0},
    {0,0,0,0,1,1,0,0,0,1,1,0,0,0,0},
    {0,0,0,0,0,1,0,0,0,0,1,0,0,0,0},
    {0,0,0,0,0,1,0,0,0,0,1,0,0,0,0},
    {0,0,0,0,0,1,0,0,0,0,1,0,0,0,0},
    {0,0,0,0,0,1,0,0,0,0,1,0,0,0,0},
    {0,0,0,0,1,1,1,0,0,1,1,1,0,0,0},
    {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    };
int Twelve[11][15] = {
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,0,0,0,1,0,0,0,1,1,1,0,0,0,0},
    {0,0,0,1,1,0,0,1,0,0,0,1,0,0,0},
    {0,0,0,0,1,0,0,0,0,0,0,1,0,0,0},
    {0,0,0,0,1,0,0,0,0,0,1,0,0,0,0},
    {0,0,0,0,1,0,0,0,0,1,0,0,0,0,0},
    {0,0,0,0,1,0,0,0,1,0,0,0,0,0,0},
    {0,0,0,1,1,1,0,1,1,1,1,1,0,0,0},
    {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    };
int Thirteen[11][15] = {
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,0,0,0,1,0,0,1,1,1,1,1,0,0,0},
    {0,0,0,1,1,0,0,0,0,0,1,0,0,0,0},
    {0,0,0,0,1,0,0,0,0,1,0,0,0,0,0},
    {0,0,0,0,1,0,0,0,0,0,1,0,0,0,0},
    {0,0,0,0,1,0,0,0,0,0,0,1,0,0,0},
    {0,0,0,0,1,0,0,1,0,0,0,1,0,0,0},
    {0,0,0,1,1,1,0,0,1,1,1,0,0,0,0},
    {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    };
int Fourteen[11][15] = {
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,0,0,0,1,0,0,0,0,0,1,0,0,0,0},
    {0,0,0,1,1,0,0,0,0,1,1,0,0,0,0},
    {0,0,0,0,1,0,0,0,1,0,1,0,0,0,0},
    {0,0,0,0,1,0,0,1,0,0,1,0,0,0,0},
    {0,0,0,0,1,0,0,1,1,1,1,1,0,0,0},
    {0,0,0,0,1,0,0,0,0,0,1,0,0,0,0},
    {0,0,0,1,1,1,0,0,0,0,1,0,0,0,0},
    {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    };
int Fifteen[11][15] = {
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,0,0,0,1,0,0,1,1,1,1,1,0,0,0},
    {0,0,0,1,1,0,0,1,0,0,0,0,0,0,0},
    {0,0,0,0,1,0,0,1,1,1,1,0,0,0,0},
    {0,0,0,0,1,0,0,0,0,0,0,1,0,0,0},
    {0,0,0,0,1,0,0,0,0,0,0,1,0,0,0},
    {0,0,0,0,1,0,0,1,0,0,0,1,0,0,0},
    {0,0,0,1,1,1,0,0,1,1,1,0,0,0,0},
    {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    };
    /*
int Sixteen[11][15] = {
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,0,0,0,1,0,0,0,0,0,1,1,0,0,0},
    {0,0,0,1,1,0,0,0,0,1,0,0,0,0,0},
    {0,0,0,0,1,0,0,0,1,0,0,0,0,0,0},
    {0,0,0,0,1,0,0,1,1,1,1,0,0,0,0},
    {0,0,0,0,1,0,0,1,0,0,0,1,0,0,0},
    {0,0,0,0,1,0,0,1,0,0,0,1,0,0,0},
    {0,0,0,1,1,1,0,0,1,1,1,0,0,0,0},
    {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    };
int Seventeen[11][15] = {
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,0,0,0,1,0,0,1,1,1,1,1,0,0,0},
    {0,0,0,1,1,0,0,0,0,0,0,1,0,0,0},
    {0,0,0,0,1,0,0,0,0,0,1,0,0,0,0},
    {0,0,0,0,1,0,0,0,0,1,0,0,0,0,0},
    {0,0,0,0,1,0,0,0,1,0,0,0,0,0,0},
    {0,0,0,0,1,0,0,0,1,0,0,0,0,0,0},
    {0,0,0,1,1,1,0,0,1,0,0,0,0,0,0},
    {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    };
int Eighteen[11][15] = {
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,0,0,0,1,0,0,0,1,1,1,0,0,0,0},
    {0,0,0,1,1,0,0,1,0,0,0,1,0,0,0},
    {0,0,0,0,1,0,0,1,0,0,0,1,0,0,0},
    {0,0,0,0,1,0,0,0,1,1,1,0,0,0,0},
    {0,0,0,0,1,0,0,1,0,0,0,1,0,0,0},
    {0,0,0,0,1,0,0,1,0,0,0,1,0,0,0},
    {0,0,0,1,1,1,0,0,1,1,1,0,0,0,0},
    {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    };
int Nineteen[11][15] = {
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,0,0,0,1,0,0,0,1,1,1,0,0,0,0},
    {0,0,0,1,1,0,0,1,0,0,0,1,0,0,0},
    {0,0,0,0,1,0,0,1,0,0,0,1,0,0,0},
    {0,0,0,0,1,0,0,0,1,1,1,1,0,0,0},
    {0,0,0,0,1,0,0,0,0,0,0,1,0,0,0},
    {0,0,0,0,1,0,0,0,0,0,1,0,0,0,0},
    {0,0,0,1,1,1,0,0,1,1,0,0,0,0,0},
    {1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    };
*/
void Blocks::init(N5110 *lcd)
{
    _lcd = lcd;
    reset = 0;
    _bx = -100; //to make sure these coordinates do not interfere with any collisions as this is a default value if conditions do not satisfy,
    _by = -100; //(NULL is in range of collisions in this game and is therefore not used.
}


void Blocks::draw(int length)
{
    _length = length;
    velocity.x = 0;
    velocity.y = 1;
    
    if(reset == 0){
        _bx = 0;
        _by = -11;
        int i=0; //this variable is used to save the positions of the random numbers generated in a block
        while(i < 5)  {
            caseselect[i] = rand()%16; //can make it 17 here later so that people are in for a shock when they think its an empty space and loose massive lives???
            i++;
        }
        round = _length/(7/2);  //to make sure at least one is smaller than the snake size
        caseselect[rand()%5] = floor(round);
        round = _length/(2); //to make sure at least two smaller than the snake size (two because one is already smaller)
        caseselect[rand()%5] = floor(round);
        reset = reset+1; //to stop this if function to keep executing.
    }
    
    Blocks::DrawFrame();
    
    Blocks::ChooseBlocks();
}

void Blocks::DrawFrame()  {
    for(int i = 3; i <= 83; i += 16) {
        _lcd->drawSprite(_bx+i,_by,11,1,(int *)Frame); //Function to draw the frame at all i coordinates as x.
    }
}

void Blocks::ChooseBlocks()  {
    int i = 0;
    int pos = 4; //this refers to the x coordinate of the blocks.
    while((i<5)&&(pos<=68))  {
        switch(caseselect[i])  {
            case 0:
                // This case creates empty block
                break;
            case 1:
                _lcd->drawSprite(pos,_by,11,15,(int *)One);
                break;
            case 2:
                _lcd->drawSprite(pos,_by,11,15,(int *)Two);
                break;
            case 3:
                _lcd->drawSprite(pos,_by,11,15,(int *)Three);
                break;
            case 4:
                _lcd->drawSprite(pos,_by,11,15,(int *)Four);
                break;
            case 5:
                _lcd->drawSprite(pos,_by,11,15,(int *)Five);
                break;
            case 6:
                _lcd->drawSprite(pos,_by,11,15,(int *)Six);
                break;
            case 7:
                _lcd->drawSprite(pos,_by,11,15,(int *)Seven);
                break;
            case 8:
                _lcd->drawSprite(pos,_by,11,15,(int *)Eight);
                break;
            case 9:
                _lcd->drawSprite(pos,_by,11,15,(int *)Nine);
                break;
            case 10:
                _lcd->drawSprite(pos,_by,11,15,(int *)Ten);
                break;
            case 11:
                _lcd->drawSprite(pos,_by,11,15,(int *)Eleven);
                break;
            case 12:
                _lcd->drawSprite(pos,_by,11,15,(int *)Twelve);
                break;
            case 13:
                _lcd->drawSprite(pos,_by,11,15,(int *)Thirteen);
                break;
            case 14:
                _lcd->drawSprite(pos,_by,11,15,(int *)Fourteen);
                break;
            case 15:
                _lcd->drawSprite(pos,_by,11,15,(int *)Fifteen);
                break;
            default:
                break;
            }
        i++;
        pos+=16;
    }
}

Vector2D Blocks::get_pos() //Obtains the X and Y coordinate of the target.
{
    Vector2D blockpos = {_bx,_by};
    //printf("blockpos is = %f %f \n", blockpos.x, blockpos.y);
    return blockpos;
}

int * Blocks::get_number() //Sends the array of all the numbers saved inside the blocks.
{
    return caseselect;
}


void Blocks::update(int blocknum, int blockgap, int srn, bool send_block_number) //send_block_number sends the block number only when the y position satisfies a particular requirement
{                                                                               //and srn gives the srn of the block, snake is colliding with.
    // this if function makes sure the block appears at the rate of blockgap.
    if(_by >= (blockgap)){
        reset = 0;
    }
    _bx += velocity.x;
    _by += velocity.y;

    if(send_block_number == true) {caseselect[srn] = blocknum;}
}


void Blocks::set_pos(Vector2D p)
{
    _bx = p.x;
    _by = p.y;
}
