#include "mbed.h"
#include "LIS2DH.h"
#include "MAX30001.h"
#include "System.h"
#include "USBSerial.h" 

/******************************************************************************/
#define LIS2DH_I2C_SLAVE_ADDR   (0x32)
 
// Settings for ECG Initialization
#define En_ecg     0x01
#define Openp      0x00
#define Openn      0x00
#define Pol        0x00
#define Calp_sel   0x00
#define Caln_sel   0x00
#define E_fit      0x0F
#define Rate       0x00
#define Gain       0x00
#define Dhpf       0x01
#define Dlpf       0x01
 
// Settings for ECG RtoR
#define En_rtor    0x01
#define Wndw       0x03
#define Gain1      0x0f
#define Pavg       0x02
#define Ptsf       0x03
#define Hoff       0x20
#define Ravg       0x02
#define Rhsf       0x04
#define Clr_rrint  0x01

// Define with Maxim VID and a Maxim assigned PID, set to version 0x0001 and 
//  non-blocking
USBSerial usbSerial(0x0b6a, 0x0100, 0x0001, false);
 
// LIS2DH I2C Master
I2C i2c2(I2C2_SDA, I2C2_SCL);
 
// SPI Master 0 with SPI0_SS for use with MAX30001
SPI spi(SPI0_MOSI, SPI0_MISO, SPI0_SCK, SPI0_SS); 
 
// Accelerometer
LIS2DH lis2dh(&i2c2, LIS2DH_I2C_SLAVE_ADDR);
InterruptIn lis2dh_Interrupt(P4_7);

// ECG device
MAX30001 max30001(&spi);
InterruptIn max30001_InterruptB(P3_6);
InterruptIn max30001_Interrupt2B(P4_5);

// PWM used as fclk for the MAX30001
PwmOut pwmout(P1_7);
  
DigitalOut led(LED1); 

// Data of sensors
int16_t Acc[3];
int32_t ECG_Raw, ECG_cumul;
double ECG_converted = 0;
uint32_t index = 0;
 
//@brief Creates a packet that will be streamed via USB Serial, the packet 
//       created will be inserted into a fifo to be streamed at a later time
//@param id     Streaming ID
//@param buffer Pointer to a uint32 array that contains the data to include in 
//       the packet
//@param number Number of elements in the buffer
void StreamPacketUint32_ex(uint32_t id, uint32_t *buffer, uint32_t number) {
    int k;
    
    if(id == MAX30001_DATA_ECG) {
        for (k = 0; k < number; k++) {
            ECG_Raw = (int32_t)(buffer[k] << 8);
            ECG_Raw = ECG_Raw >> 14;
            usbSerial.printf("ECG\r\n");
            usbSerial.printf("%d\r\n", ECG_Raw);
            index++; 
        }
    }
}

int main() {
    // Hold results for returning functions
    int result;
    
    // Interrupt priority    
    NVIC_SetPriority(GPIO_P0_IRQn, 5);
    NVIC_SetPriority(GPIO_P1_IRQn, 5);
    NVIC_SetPriority(GPIO_P2_IRQn, 5);
    NVIC_SetPriority(GPIO_P3_IRQn, 5);
    NVIC_SetPriority(GPIO_P4_IRQn, 5);
    NVIC_SetPriority(GPIO_P5_IRQn, 5);
    NVIC_SetPriority(GPIO_P6_IRQn, 5);
    // Used by the MAX30001
    NVIC_SetPriority(SPI1_IRQn, 0);
    
    /* ECG Initialize */
    max30001_InterruptB.disable_irq();
    max30001_Interrupt2B.disable_irq();
    max30001_InterruptB.mode(PullUp);
    max30001_InterruptB.fall(&MAX30001Mid_IntB_Handler);
    max30001_Interrupt2B.mode(PullUp);
    max30001_Interrupt2B.fall(&MAX30001Mid_Int2B_Handler);
    max30001_InterruptB.enable_irq();
    max30001_Interrupt2B.enable_irq();
    MAX30001_AllowInterrupts(1);    
    // Configuring the FCLK for the ECG, set to 32.768KHZ
    pwmout.period_us(31);
    pwmout.write(0.5);          // 0-1 is 0-100%, 0.5 = 50% duty cycle.
    max30001.max30001_sw_rst(); // Do a software reset of the MAX30001
    max30001.max30001_INT_assignment(
        MAX30001::MAX30001_INT_B,  // en_enint_loc
        MAX30001::MAX30001_NO_INT, // en_eovf_loc
        MAX30001::MAX30001_NO_INT, // en_fstint_loc

        MAX30001::MAX30001_INT_2B, // en_dcloffint_loc
        MAX30001::MAX30001_INT_B, // en_bint_loc
        MAX30001::MAX30001_NO_INT, // en_bovf_loc

        MAX30001::MAX30001_INT_2B, // en_bover_loc
        MAX30001::MAX30001_INT_2B, // en_bundr_loc
        MAX30001::MAX30001_NO_INT, // en_bcgmon_loc

        MAX30001::MAX30001_INT_B,  // en_pint_loc
        MAX30001::MAX30001_NO_INT, // en_povf_loc,
        MAX30001::MAX30001_NO_INT, // en_pedge_loc

        MAX30001::MAX30001_INT_2B, // en_lonint_loc
        MAX30001::MAX30001_INT_B,  // en_rrint_loc
        MAX30001::MAX30001_NO_INT, //  en_samp_loc

        MAX30001::MAX30001_INT_ODNR,  // intb_Type
        MAX30001::MAX30001_INT_ODNR); // int2b_Type

    lis2dh.initStart(LIS2DH_DATARATE_50HZ, LIS2DH_FIFO_SIZE);
    max30001.max30001_ECG_InitStart(En_ecg, Openp, Openn, Pol, Calp_sel, 
                                    Caln_sel, E_fit, Rate, Gain, Dhpf, Dlpf);
    max30001.max30001_synch();
    max30001.onDataAvailable(&StreamPacketUint32_ex);

    while (1){
        int a;
        lis2dh.get_motion_fifo(&Acc[0], &Acc[1], &Acc[2]);
        usbSerial.printf("ACC\r\n");
        usbSerial.printf("X %d\r\nY %d\r\nZ %d\r\n", Acc[0], Acc[1], Acc[2]);
    } 
}
