#include "mbed.h"               //Si se toca el pulsador comienza la secuencia de "Blinky LED" 
                                //Si se vuelve a presionar, se apaga el LED
    //Declaración de valores de estados
enum {ON = 0,
      OFF = 1,
      COMP = 1,
      INC = 0,
      S_OFF = 0,
      S_WAIT,
      S_ON,
      S_OUT = 0,
      S_LON, S_LOFF}; 

//Seteo de entradas y salidas
DigitalIn Puls(PTB8);   //Este tiene una configuracion PULL_UP (Presionado => "0"/ NO Presionado => "1")
DigitalOut LedRojo(LED1);

Ticker wait_puls, wait_led; //Seteo de nombres de objetos tipo "Ticker"
 
//Prototipos de funciones
void SM_ANTI_REBOTE();
void SM_BLINKING_LED();
void interrupt_puls();
void interrupt_led();
//Seteo de valores iniciales de variables que funcionan como memorias
int blink = OFF,
    state_pul = 0,
    state_b,
    timeP_complete = INC,
    timeL_complete = INC;

int main(void){   //Función de los objetos
    wait_puls.attach(&interrupt_puls,0.1);  //Llamará a la función "interrupt_puls" cada 0.1s (100ms)  
    wait_led.attach(&interrupt_led,0.5);    //Llamará a la función "interrupt_led" cada 0.5s (500ms)
    while(true){ //Función infinita (LOOP)
        //Llamado de las funciones
        SM_ANTI_REBOTE();
        SM_BLINKING_LED();        
    }          
}
// -------------------------------------------------------------------------------------------------------
//A partir de este comentario se realizarán las definiciones de cada función

//Máquina de estados de un "Debounce Switch" (Pulsador Antirrebote)
void SM_ANTI_REBOTE(void){   //Este switch variará según el estado del pulsador
    switch (state_pul){
        //Estado "LED apagado/Pulsador NO presionado"
        case S_OFF: 
            blink = OFF;
            if(Puls == ON)   //Si detecta un pulso bajo en el pulsador
                state_pul = S_WAIT;   //Cambio de estado
        break;
        //Estado antirrebote del pulsador
        case S_WAIT:
            if(timeP_complete == COMP && Puls == ON && blink == OFF){   //Evalúa si se da inicio a la secuencia   
                state_pul = S_ON;   //Cambio de estado
                timeP_complete = INC;
            }
            else if(timeP_complete == COMP && Puls == ON && blink == ON){   //Evaúa si se está finalizando la secuencia
                state_pul = S_OFF;   //Cambio de estado
                timeP_complete = INC;        
            }
        break;
        //Estado "Blinky LED/Pulsador NO presionado"
        case S_ON:
            blink = ON;
            if(Puls == ON)
                state_pul = S_WAIT;   //Cambio de estado
        break;                  
    }
}
//Máquina de estados del "Blinky LED" (LED Titilando)
void SM_BLINKING_LED(void){ 
    switch (state_b){
        //Estado Espera Pulsador/LED apagado
        case S_OUT:
            LedRojo = OFF;
            if(blink == ON)
                state_b = S_LON;   //Cambio de estado
        break;
        //Estado LED prendido por 500ms
        case S_LON:
            LedRojo = ON;
            if (timeL_complete == COMP){
                state_b = S_LOFF;
                timeL_complete = INC;
            }
            else if (blink == OFF)
                state_b = S_OUT;   //Cambio de estado
        break;
        //Estado LED apagado por 500ms
        case S_LOFF:
            LedRojo = OFF;
            if (timeL_complete == COMP){
                state_b = S_LON;
                timeL_complete = INC;
            }
            else if (blink == OFF)
                state_b = S_OUT;   //Cambio de estado
        break;    
    }
}  
//Esta función hará posbile el parpadeo del LED      
void interrupt_led(void){       
    timeL_complete = COMP;
}
//Esta función hará posible el antirrebote del pulsador
void interrupt_puls(void){
    timeP_complete = COMP;   
}