#include "mbed.h"                   //Codificación MANCHESTER :
                                        //Si DATA = 1 ==> Manchester_OUT = CLK
                                        //Si DATA = 0 ==> Manchester_OUT = !CLK
    //Declaración de valores de estados
enum {S_clock,                          
      S_clock_neg,
      BITS = 8};

Ticker Clock;   //Seteo de nombre de objeto tipo "Ticker"

//Seteo de salidas
DigitalOut Red(PTC0);
DigitalOut Blue(PTC3);

//Prototipos de funciones
void Emisor(void);
void attime_clock(void);
//Seteo de los valores iniciales de las variables utilizadas como memorias
unsigned char Clk = 1,
              Num_Clock = 8,
              Manchester_Out = 0,
              cycle;
int DATA[8] = {1,1,1,1,0,0,0,0}; //Seteo fijo de "DATA" para la prueba del emisor (La DATA entrante siempre toma 1 período de CLK)

int main(void){    
    Clock.attach(&attime_clock, 0.1);  //LLamará a la función "attime_clock" cada "TIME". TIME = 1s (línea 5)
    while(true){
        //Llamado de función
        Emisor();
        Blue = !Clk;    //Para poder visualizar el desfasaje hecho con el OUT, se niega el CLK
        Red = Manchester_Out;  //Se le asignará al LED Rojo la salida codificada para poder visualizarlo mejor
    }
}

// -------------------------------------------------------------------------------------------------------
//A partir de este comentario se realizarán las definiciones de cada función

//Máquina de estados de la codificación
void Emisor(void){
    switch(DATA[Num_Clock-1]){
        //Si DATA = 0 ==> OUT = !CLK
        case S_clock:
            Manchester_Out = !Clk;
        break;
        //Si DATA = 1 ==> OUT = CLK
        case S_clock_neg:
            Manchester_Out = Clk;
        break;
    }
}
//Esta función será la encargada de crear una 
void attime_clock(void){
    Clk = !Clk; //Se niega el valor anterior de CLK para hacer una señal cuadrada sincrónica
    if(Clk == 0)
        cycle = 1;
    if (cycle == 1 && Clk == 1){    //Al pasar un período de CLK, se sumará Num_Clock para seguir con la próxima DATA
        Num_Clock = Num_Clock - 1;
        cycle = 0;
    }
    if (Num_Clock == 0)  //Si se llegan a la cantidad de BITS (8 bits), volverá a "0" y se hará una DATA infinita
        Num_Clock = 8;
}