#include "mbed.h"
#include "rtos.h"
#include "ModbusSlave232.h" //see readme
#include "millis.h" //see readme

ModbusSlave232 mbs; // Create new mbs instance

// Slave registers
enum {        
  MB_0,   // Register 0
  MB_1,   // Register 1
  MB_2,   // Register 2
  MB_3,   // Register 3  
  MB_4,   // Register 4  
  MB_REGS // Dummy register. using 0 offset to keep size of array
};

DigitalOut led1(LED1);

int regs[MB_REGS];

void another_thread(void const *argument) // do stuff
{
    while (true) {
        Thread::wait(100); 
        led1 = !led1;
    }
}

int main()
{
    const unsigned char SLAVE = 1;
    const long BAUD = 9600;            
    const unsigned PARITY = 'n';
    
    startMillis(); // milliseconds (arduino like)

    mbs.configure(SLAVE, BAUD, PARITY);

    Thread thread(another_thread, NULL, osPriorityNormal, DEFAULT_STACK_SIZE);
    
    //test values (updatable)  
    regs[MB_0] = 0xCA1F;
    regs[MB_1] = 0xFACE;
    regs[MB_2] = 0xC0DE;
    regs[MB_3] = 0x1234;
    
    while (true) //main thread
    {                
        mbs.update(regs, MB_REGS); // Pass current register values to mbs
        Thread::wait(10); // not too sure if this is needed
    }
}