/*********************************************************
*buggy_functions.cpp                                     *
*Author: Elijah Orr & Dan Argust                         *
*                                                        *
*A library of functions that can be used to control the  *
*RenBuggy.                                               *
*********************************************************/

#ifndef BUGGY_FUNCTIONS_C
#define BUGGY_FUNCTIONS_C

/* necessary includes */
#include "mbed.h"
#include "buggy_function.h"
#include "Microbit_function.h"

//Trim is an offset that you can adjust to help the buggy drive straight
//Trim = -0.2 is a left trim
//Trim =  0.2 is a right trim
float trim = 0.0;

//Set up PWM on both left and right motor pins.
PwmOut Lmotor(LeftMotorPin);
PwmOut Rmotor(RightMotorPin);

Direction Current_Direction = Up;

//DigitalIn is used as a button
DigitalIn CurrentButtonState(p7);
//This bool is used to store the buttons state (pressed/not pressed)
bool LastButtonState = 0;


/* Functions (listed below) contain the code that runs the buggy.
These functions can be used in the main.cpp file */


extern void hold(float time) //waits for (time) seconds
{
    //seg.DisplayDigits(0,0); //Displays the digits 0 and 0
    for (float i = time;i>0;i-=0.01){ //For every hundreth of a second, display the time remaining
        Display(Current_Direction);
       wait(0.01);
    }
    Display(Clear);
}

extern void forward(float time) //moves forward for (time) seconds
{
    Lmotor = 0.7 + trim;
    Rmotor = 0.7 - trim; //set the left and right motor to 1.0 (full speed) - the trim offset
    Current_Direction = Up;
    hold(time); //wait for (time) seconds while the motors are on
    stop(); //stops the motors
}

extern void left(float time) //moves left for (time) seconds
{
    Lmotor = 0.0; //set the right motor to full speed
    Rmotor = 0.7 - trim; //set the left motor to off
    Current_Direction = Left;
    hold(time); //waits for (time) seconds
    stop(); //stops the motors
}

extern void right(float time) //moves right for (time) seconds
{
    Lmotor = 0.7 + trim; //set the left motor to full speed
    Rmotor = 0.0; //set the right motor to off
    Current_Direction = Right;
    hold(time); //waits for (time) seconds
    stop(); //stops the motors
}

extern void bear_Right(float time) //keeps both motors turning but will turn right
{
    Lmotor =  0.7 + trim; //sets the left motor to full speed
    Rmotor = 0.1; // sets the right motor to move slowly
    Current_Direction = TopRight; //Sets the direction to be top right
    hold(time); // wait for (time) seconds.
    stop(); // stops both motors.
}

extern void bear_Left(float time) // keeps both motors turning but it should slowly turn left
{
    Lmotor = 0.1; // sets the left motor to move slowly
    Rmotor = 0.7 - trim; // sets the right motor to move at full speed
    Current_Direction =  TopLeft; // sets the direction to be the top left.
    hold(time); // wait for (time) seconds
    stop(); // stops both motors
}
extern void stop() //stops the motors
{
    Lmotor = Rmotor = 0; //set the speed of each motor to 0
    Current_Direction = Stop;
}

extern void readButton(float time) //checks if the button is pressed for (time) seconds
{
    //seg.DisplayDigits(0,0); //displays 0 0 on the seven segment display
    for (float i = time;i>0;i-=0.01) //for each hundreth of a seconds check if the button state goes from low to high (eg. pressed)
    {
        if (CurrentButtonState == 1 and LastButtonState == 0){
            rollDice(); //rolls the dice if the button is pressed
        }
        LastButtonState = CurrentButtonState;
        wait(0.01);
    }
}

extern int rollDice() //a function that randomly generates a number and displays it on the seven segment display
{
    int tens; //declare two variables, tens and units to store the number to be displayed
    int units;
    for (int i = 20;i>0;i--){
        tens = rand()%9; //generate a random number from 0-9 and store it in "tens"
        units = rand()%9;
        //seg.DisplayDigits(tens,units); //display the numbers stored in tens and units
        wait(0.04);
    }
    return tens*10+units;
}

extern void follow_Line(float time) //a function that uses the built in ADCs to command the buggy to follow a black line for time.
{
    int direction_Data; //declares a variable uses to store the direction data.
    for (float i = time; i > 0 ; i -= follow_Speed) // will repeat until time is up.
    {
        direction_Data = left_Sensor() - right_Sensor(); //Compare left sensor and right sensor.
        //if direction data is positive then the right sensor is on white.
        //if direction data is negative then the left sensor is on white.
        if(direction_Data > 100) //data direction is significantly positive.
        {
            left(follow_Speed); //turns left for follow_Speed.
        }
        else if (direction_Data < -100 ) //data direction is significantly negative
        {
            right(follow_Speed); // turns right for follow_Speed
        }
        else // else if both sensors are within each other. 
        {
            forward(follow_Speed); // heads forward for follow_Speed.
        }
    }
}

extern void follow_Line() // a functoin that will follow a black line forever.
{
    int direction_Data; //declares a variable used to store the direction data.
    for (;;) //This creates a loop which will go on forever.
    { 
        direction_Data = left_Sensor() - right_Sensor(); // Combines both sets of direction data into one variable.
        if(direction_Data > 100) // if direction data is signficantly positive
        {
            left(follow_Speed);// Turn left, as the buggy is leaving the black line.
        }
        else if (direction_Data < -100 ) // if direction data is significantly negative
        {
            right(follow_Speed); //turn right, as the buggy is leaving the black line.
        }
        else // if neither other conditions are met then go forward.
        {
            forward(follow_Speed); // go forward, as the buggy is on the black line.
        }
    }
}


#endif // BUGGY_FUNCTIONS_C