/*********************************************************
*buggy_functions.h                                       *
*Author: Elijah Orr & Dan Argust                         *
*                                                        *
*A library of functions that can be used to control the  *
*RenBuggy.                                               *
*********************************************************/

/* include guards are used to prevent problems caused by 
multiple definitions */
#ifndef BUGGY_FUNCTIONS_H
#define BUGGY_FUNCTIONS_H

/* mbed.h must be included in this file also */


/* #define LeftMotorPin P0_3 tells the preprocessor to replace
any mention of LeftMotorPin with P0_3 etc. 
This currently used the Large pads labled 0 and 1.
P0_18 is equivelent to pad 8.
P0_16 is equivelent to pad 16.
potential pads could be P0,P1,P8,P12,P2,P16
*/
#define LeftMotorPin P0_18
#define RightMotorPin P0_16
#define follow_Speed 0.3


/*This typedef defines what direction the buggy can go in, it is also used to determine what to display.*/
typedef enum {
    Up,
    Down,
    Left,
    Right,
    TopLeft,
    TopRight,
    BottomLeft,
    BottomRight,
    Stop,
    Clear,
}Direction;

/* these are function prototypes that declare all the functions
in the library.*/
extern void forward(float); //Move the buggy forward for (float) seconds
extern void left(float); //Turn left for (float) seconds
extern void right(float); //Turn right for (float) seconds
extern void hold(float); //Hold the buggy in an idle state for (float) seconds
extern void bear_Right(float); // Turns the buggy to the right while moving forward
extern void bear_Left(float); // Turns the buggy to the left while moving forward
extern void stop(); //Stop all motors
extern void follow_Line(float);
extern void follow_Line();

extern void readButton(float); //Similar to hold, but scans for button presses while waiting
extern int rollDice(); //Randomly generate a number a display it on the seven segment display


/* stop() and rollDice() do not need to be giving a float
to be run unlike the other functions which use a (float)
to know how long they should run for */

#endif // BUGGY_FUNCTIONS_H