
#include "Microbit_function.h"
#include "mbed.h"

MicroBit uBit;

// These MiroBit images are used by the Display function to indicate what direction the buggy will travel in.
MicroBitImage arrow_Up("0,0,1,0,0\n0,1,1,1,0\n1,0,1,0,1\n0,0,1,0,0\n0,0,1,0,0\n");
MicroBitImage arrow_Down("0,0,1,0,0\n0,0,1,0,0\n1,0,1,0,1\n0,1,1,1,0\n0,0,1,0,0\n");
MicroBitImage arrow_Left("0,0,1,0,0\n0,1,0,0,0\n1,1,1,1,1\n0,1,0,0,0\n0,0,1,0,0\n");
MicroBitImage arrow_Right("0,0,1,0,0\n0,0,0,1,0\n1,1,1,1,1\n0,0,0,1,0\n0,0,1,0,0\n");
MicroBitImage arrow_TopLeft("1,1,1,0,0\n1,1,0,0,0\n1,0,1,0,0\n0,0,0,1,0\n0,0,0,0,1\n");
MicroBitImage arrow_TopRight("0,0,1,1,1\n0,0,0,1,1\n0,0,1,0,1\n0,1,0,0,0\n1,0,0,0,0\n");
MicroBitImage arrow_BottomLeft("0,0,0,0,1\n0,0,0,1,0\n1,0,1,0,0\n1,1,0,0,0\n1,1,1,0,0\n");
MicroBitImage arrow_BottomRight("1,0,0,0,0\n0,1,0,0,0\n0,0,1,0,1\n0,0,0,1,1\n0,0,1,1,1\n");
MicroBitImage cross("1,0,0,0,1\n0,1,0,1,0\n0,0,1,0,0\n0,1,0,1,0\n1,0,0,0,1\n");
MicroBitImage On("1,1,1,1,1\n1,1,1,1,1\n1,1,1,1,1\n1,1,1,1,1\n1,1,1,1,1\n");

//
MicroBitPin P0(MICROBIT_ID_IO_P0, MICROBIT_PIN_P0, PIN_CAPABILITY_ALL); 
MicroBitPin P1(MICROBIT_ID_IO_P1, MICROBIT_PIN_P1, PIN_CAPABILITY_ALL); 

extern void microBit_Setup()
{
    uBit.init();
}

extern void Display(Direction Current_Direction) // This function is used to simply display the direction the motors are turning
{
    switch(Current_Direction) // Displays the related arrow accoring to which direction the buggy is moving in.
    {
        case Up:            uBit.display.printAsync(arrow_Up);           break;
        case Down:          uBit.display.printAsync(arrow_Down);         break;
        case Right:         uBit.display.printAsync(arrow_Right);        break;
        case Left:          uBit.display.printAsync(arrow_Left);         break;
        case TopLeft:       uBit.display.printAsync(arrow_TopLeft);      break;
        case BottomLeft:    uBit.display.printAsync(arrow_BottomLeft);   break;
        case TopRight:      uBit.display.printAsync(arrow_TopRight);     break;
        case BottomRight:   uBit.display.printAsync(arrow_BottomRight);  break;
        case Stop:          uBit.display.printAsync(cross);              break;
        case Clear:         uBit.display.clear();                        break;
    }
}
extern void pointNorth() //This function Will direct the buggy to face North
{
    int direction = uBit.compass.heading(); //Declare a variable to store the direction in
    while((direction > 2) && (direction < 358)) // While it is not facing north
    {
        if (direction <= 180) // if it is less then 180 then turn left
        {
            left(0.1);
        }
        if (direction > 180) // if it is more then 180 then turn right
        {
            right(0.1);
        }
        direction = uBit.compass.heading(); // check the direction again
    }
}

extern void pointSouth() // this function is similar to hedNorth but will point to South instead
{
    int direction = uBit.compass.heading(); //Declares a variable which will be used to store the direction
    while((direction < 178) || (direction > 182)) //While it is not pointing South
    {
        if ((direction > 180) && (direction <= 360)) // if it is between 180 and 360 turn left.
        {
            left(0.1);
        }
        if ((direction > 0) && (direction <=180)) // if it is less than 180 turn right.
        {
            right(0.1);
        }
        direction = uBit.compass.heading(); // check the direction again
    }
}

extern Compass_Dirs Compass() // this function is designed to display the direction the microbit is facing, and returns that value.
{
    int direction = uBit.compass.heading(); // declare a variable to be used for storing the direction.
    if((direction < 45) || (direction >= 325)) // if the direciton is pointing generally north then output North.
    {
        uBit.display.print("N");
        return North;
    }
    else if((direction < 135) && (direction >= 45)) // if the direction is generally east then output east.
    {
        uBit.display.print("E");
        return East;
    }
    else if((direction < 225) && (direction >= 135)) // if the direction is generally South then output south
    {
        uBit.display.print("S");
        return South;
    }
    else if((direction < 325) && (direction >= 225)) // if the direction is generally West then output West.
    {
        uBit.display.print("W");
        return West;
    }
    return Default;
}

extern int left_Sensor()// This function returns the analogue voltage on the left sensor.
{
    return P0.getAnalogValue(); //This is the function that actually get the voltage.
}

extern int right_Sensor() //This function returns the analogue voltage of the right sensor.
{
    return P1.getAnalogValue(); //gets the voltage on P1, should be connected to the right sensor.
}