#include "mbed.h"
#include "toolchain.h"
#include "ble/BLE.h"
#include "spi_master.h"


/////////////////////////////SPI//////////////////////
SPIClass SPI1(NRF_SPI1);
//# CS      P0_14
//# SCK     P0_25
//# MOSI    P0_20"
//# MISO    P0_22
DigitalOut spi_cs(P0_7);
/////////////////////////////////////////////////////

DigitalIn esp_baglimi(P0_11);

////////////////////////////////DATA_FORMATIM///////////////////////////////////////////////////////

Serial pc(TX_PIN_NUMBER, P0_3/*RX_PIN_NUMBER*/);

#define ToplamCihaz 1// (10) hakan değiştir 01122016
#define bufferSize 60
uint8_t       bulunan_index[ToplamCihaz];
struct Medron_Data
{    
        uint8_t                         MacID[6];   // MAC ID leri bunun içinde tutacağız
        uint8_t                         RSSI;   // MAC ID leri bunun içinde tutacağız
        uint8_t                         LENGTH;
        uint8_t                         MYDATA[50];
        uint8_t                         PAKET_LENGTH;//SPI'YDAN STM32'YE GÖNDERİLCEK DATANIN TOPLAM
                                                     //UZUNLUGU. 
} PACKED_Data[ToplamCihaz]; 
//////////////////////////////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////////////////////////////
// ÖZEL BİR BEACON ALIYORSAK BU KULLANILIR. ARANACAK OLAN BEACON SAYILARI BELİRTİLMELİ
// VE BEACON MAC ID'SI SİSTEME TANITILMALIDIR. 
#define ARANAN_MAC_SAYI 6
typedef struct
{
    uint8_t mac_id[6];
}Beacon_MAC_ID; 
Beacon_MAC_ID b_mac[ARANAN_MAC_SAYI];
uint8_t say=0;

void mac_id_gir()
{          
      
   //ISIK SENSOR 
   b_mac[0].mac_id[5]=0xAC;
   b_mac[0].mac_id[4]=0x23;
   b_mac[0].mac_id[3]=0x3F;
   b_mac[0].mac_id[2]=0xB0;
   b_mac[0].mac_id[1]=0x42;
   b_mac[0].mac_id[0]=0x12;

   //hum+temp  s1  SENSOR 
   b_mac[1].mac_id[5]=0xAC;
   b_mac[1].mac_id[4]=0x23;
   b_mac[1].mac_id[3]=0x3F;
   b_mac[1].mac_id[2]=0xa0;
   b_mac[1].mac_id[1]=0x03;
   b_mac[1].mac_id[0]=0xcd;  
   
   
/*   //personel   SENSOR 
   b_mac[2].mac_id[5]=0xe7;
   b_mac[2].mac_id[4]=0x5e;
   b_mac[2].mac_id[3]=0xb3;
   b_mac[2].mac_id[2]=0x21;
   b_mac[2].mac_id[1]=0x69;*
   b_mac[2].mac_id[0]=0xa6;  */
   
  //personel   SENSOR 
   b_mac[2].mac_id[5]=0xCF;
   b_mac[2].mac_id[4]=0x70;
   b_mac[2].mac_id[3]=0x44;
   b_mac[2].mac_id[2]=0xD7;
   b_mac[2].mac_id[1]=0x12;
   b_mac[2].mac_id[0]=0xA8;  
   
   
  //motion   SENSOR 
   b_mac[3].mac_id[5]=0xC7;
   b_mac[3].mac_id[4]=0x6E;
   b_mac[3].mac_id[3]=0x50;
   b_mac[3].mac_id[2]=0x70;
   b_mac[3].mac_id[1]=0x64;
   b_mac[3].mac_id[0]=0x6E;  
   
    //hum+temp  s1  SENSOR 
   b_mac[4].mac_id[5]=0xAC;
   b_mac[4].mac_id[4]=0x23;
   b_mac[4].mac_id[3]=0x3F;
   b_mac[4].mac_id[2]=0xa0;
   b_mac[4].mac_id[1]=0x04;
   b_mac[4].mac_id[0]=0x43;
   
   //motion   SENSOR 
   b_mac[5].mac_id[5]=0xE6;
   b_mac[5].mac_id[4]=0xD0;
   b_mac[5].mac_id[3]=0x4C;
   b_mac[5].mac_id[2]=0xFC;
   b_mac[5].mac_id[1]=0x4C;
   b_mac[5].mac_id[0]=0xB8;    
}
////////////////////////////////////////////////////////////////////////////////////////////////

void Flash_Buff_WriteBytes(uint16_t addr, uint8_t *pbuf, uint16_t len)
{
    uint16_t index;
    
    spi_cs = 0;
    wait_us(20);     
    for(index=0; index<len; index++)
    {
        SPI1.transfer(*pbuf);
        pbuf++;        
    }
    
    wait_us(20);
    spi_cs = 1;
}

/*
   This function is called every time we scan an advertisement.
*/
void advertisementCallback(const Gap::AdvertisementCallbackParams_t *params)
{
  
        /*   EXAMPLE
          
                 fa 8c b3 c7 1c 61 :MAC ; 6 BYTE
                 2b:RSSI;1BYTE
                 0a:UZUNLUK;1BYTE-->0A H=10 D
                 09  ff cd ab 01 00 4d 52 e8 00 00 00 00 00 00 00 00 00 00 00 ;DATA
                 1   2  3  4  5  6  7  8  9  10  X  X  X  X  X  X  X  X  X  X ;DATA SAYISI
          
                 c8 60 85 e2 73 e2 :MAC:6
                 37:RSSI:1
                 08:LENGTH:1
                 07 ff cd ab 00 00 e7 00:DATA
                 1  2  3  4   5  6  7  8 ;DATA SAYISI
             */
             
  struct AdvertisingData_t
  {
    uint8_t                        length; /* doesn't include itself */
    GapAdvertisingData::DataType_t dataType;
    uint8_t                        data[0];
  } PACKED;

  struct ApplicationData_t
  {
    uint16_t applicationSpecificId;             /* An ID used to identify temperature value
                                                       in the manufacture specific AD data field */
  } PACKED;


          for (uint8_t macsay=0; macsay < ARANAN_MAC_SAYI; macsay++)
          {
          
            if ((         params->peerAddr[5] == b_mac[macsay].mac_id[5]     &&  params->peerAddr[4] == b_mac[macsay].mac_id[4]
                       && params->peerAddr[3] == b_mac[macsay].mac_id[3]     &&  params->peerAddr[2] == b_mac[macsay].mac_id[2]
                       && params->peerAddr[1] == b_mac[macsay].mac_id[1]     &&  params->peerAddr[0] == b_mac[macsay].mac_id[0] ))
            {
              
                        PACKED_Data[say].MacID[5] = params->peerAddr[5];
                        PACKED_Data[say].MacID[4] = params->peerAddr[4];
                        PACKED_Data[say].MacID[3] = params->peerAddr[3];
                        PACKED_Data[say].MacID[2] = params->peerAddr[2];
                        PACKED_Data[say].MacID[1] = params->peerAddr[1];
                        PACKED_Data[say].MacID[0] = params->peerAddr[0];
               //IŞIK İSE
                 if ((    params->peerAddr[5] ==0xac      &&   params->peerAddr[4] ==0x23 
                       && params->peerAddr[3] ==0x3f      &&   params->peerAddr[2] ==0xb0 
                       && params->peerAddr[1] ==0x42      &&   params->peerAddr[0] ==0x12))
                 {  
                         PACKED_Data[say].RSSI = (params->rssi) * -1;
                         PACKED_Data[say].LENGTH = 10; //params->advertisingDataLen;
                         PACKED_Data[say].PAKET_LENGTH = 6 + 1 + 1 + 10; //MAC+RSSI+1+LENGTH  
                       
                         pc.printf("TOPLAM PAKET UZUNLUK = (%d ) : ---> ", PACKED_Data[say].PAKET_LENGTH);          
                         PACKED_Data[say].MYDATA[0] = 0x07;
                         PACKED_Data[say].MYDATA[1] = 0xff;
                         
                         PACKED_Data[say].MYDATA[2] = 0xef;//medrona ait olmayan beaconlar için, abcd değil
                         PACKED_Data[say].MYDATA[3] = 0xab;
                         
                         PACKED_Data[say].MYDATA[4] = 0x08;// tipi elle girilmiş.
                         PACKED_Data[say].MYDATA[5] = 0x00;

                         PACKED_Data[say].MYDATA[6] = params->advertisingData[14];// ISIK
                         PACKED_Data[say].MYDATA[7] = 0x00;
                         
                         PACKED_Data[say].MYDATA[8] = params->advertisingData[13];//PİL
                         PACKED_Data[say].MYDATA[9] = 0x00;
                 } 
                 
                  if ((   params->peerAddr[5] ==0xac      &&   params->peerAddr[4] ==0x23 
                       && params->peerAddr[3] ==0x3f      &&   params->peerAddr[2] ==0xa0 
                       && params->peerAddr[1] ==0x03      &&   params->peerAddr[0] ==0xcd))
                 {  
                         PACKED_Data[say].RSSI = (params->rssi) * -1;
                         PACKED_Data[say].LENGTH = 12; //params->advertisingDataLen;
                         PACKED_Data[say].PAKET_LENGTH = 6 + 1 + 1 + 12; //MAC+RSSI+1+LENGTH  
                       
                         pc.printf("TOPLAM PAKET UZUNLUK = (%d ) : ---> ", PACKED_Data[say].PAKET_LENGTH);          
                         PACKED_Data[say].MYDATA[0] = 0x07;
                         PACKED_Data[say].MYDATA[1] = 0xff;
                         
                         PACKED_Data[say].MYDATA[2] = 0xef;//medrona ait olmayan beaconlar için, abcd değil
                         PACKED_Data[say].MYDATA[3] = 0xab;
                         
                         PACKED_Data[say].MYDATA[4] = 0x09;// tipi elle girilmiş.
                         PACKED_Data[say].MYDATA[5] = 0x00;

                         PACKED_Data[say].MYDATA[6] = params->advertisingData[14];// temp
                         PACKED_Data[say].MYDATA[7] = params->advertisingData[15];
                         
                         PACKED_Data[say].MYDATA[8] = params->advertisingData[16];//hum
                         PACKED_Data[say].MYDATA[9] = params->advertisingData[17];
                         
                         PACKED_Data[say].MYDATA[10] = params->advertisingData[13];//PİL
                         PACKED_Data[say].MYDATA[11] = 0x00;                        
                 } 
                
                  if ((   params->peerAddr[5] ==0xac      &&   params->peerAddr[4] ==0x23 
                       && params->peerAddr[3] ==0x3f      &&   params->peerAddr[2] ==0xa0 
                       && params->peerAddr[1] ==0x04      &&   params->peerAddr[0] ==0x43))
                 {  
                         PACKED_Data[say].RSSI = (params->rssi) * -1;
                         PACKED_Data[say].LENGTH = 12; //params->advertisingDataLen;
                         PACKED_Data[say].PAKET_LENGTH = 6 + 1 + 1 + 12; //MAC+RSSI+1+LENGTH  
                       
                         pc.printf("TOPLAM PAKET UZUNLUK = (%d ) : ---> ", PACKED_Data[say].PAKET_LENGTH);          
                         PACKED_Data[say].MYDATA[0] = 0x07;
                         PACKED_Data[say].MYDATA[1] = 0xff;
                         
                         PACKED_Data[say].MYDATA[2] = 0xef;//medrona ait olmayan beaconlar için, abcd değil
                         PACKED_Data[say].MYDATA[3] = 0xab;
                         
                         PACKED_Data[say].MYDATA[4] = 0x09;// tipi elle girilmiş.
                         PACKED_Data[say].MYDATA[5] = 0x00;

                         PACKED_Data[say].MYDATA[6] = params->advertisingData[14];// temp
                         PACKED_Data[say].MYDATA[7] = params->advertisingData[15];
                         
                         PACKED_Data[say].MYDATA[8] = params->advertisingData[16];//hum
                         PACKED_Data[say].MYDATA[9] = params->advertisingData[17];
                         
                         PACKED_Data[say].MYDATA[10] = params->advertisingData[13];//PİL
                         PACKED_Data[say].MYDATA[11] = 0x00;                        
                 } 
                 

                              
                  if ((   params->peerAddr[5] ==0xCF      &&   params->peerAddr[4] ==0x70 
                       && params->peerAddr[3] ==0x44      &&   params->peerAddr[2] ==0xD7 
                       && params->peerAddr[1] ==0x12      &&   params->peerAddr[0] ==0xA8))
                 {  
                         PACKED_Data[say].RSSI = (params->rssi) * -1;
                         PACKED_Data[say].LENGTH = 6; //params->advertisingDataLen;
                         PACKED_Data[say].PAKET_LENGTH = 6 + 1 + 1 + 6; //MAC+RSSI+1+LENGTH  
                       
                         pc.printf("TOPLAM PAKET UZUNLUK = (%d ) : ---> ", PACKED_Data[say].PAKET_LENGTH);          
                         PACKED_Data[say].MYDATA[0] = 0x07;
                         PACKED_Data[say].MYDATA[1] = 0xff;
                         
                         PACKED_Data[say].MYDATA[2] = 0xef;//medrona ait olmayan beaconlar için, abcd değil
                         PACKED_Data[say].MYDATA[3] = 0xab;
                         
                         PACKED_Data[say].MYDATA[4] = 0x05;// tipi elle girilmiş.
                         PACKED_Data[say].MYDATA[5] = 0x00;                
                 } 
                 
                  if ((   params->peerAddr[5] ==0xC7      &&   params->peerAddr[4] ==0x6E
                       && params->peerAddr[3] ==0x50      &&   params->peerAddr[2] ==0x70 
                       && params->peerAddr[1] ==0x64      &&   params->peerAddr[0] ==0x6E))
                 {  
                         PACKED_Data[say].RSSI = (params->rssi) * -1;
                         PACKED_Data[say].LENGTH = 6; //params->advertisingDataLen;
                         PACKED_Data[say].PAKET_LENGTH = 6 + 1 + 1 + 6; //MAC+RSSI+1+LENGTH  
                       
                         pc.printf("TOPLAM PAKET UZUNLUK = (%d ) : ---> ", PACKED_Data[say].PAKET_LENGTH);          
                         PACKED_Data[say].MYDATA[0] = 0x07;
                         PACKED_Data[say].MYDATA[1] = 0xff;
                         
                         PACKED_Data[say].MYDATA[2] = 0xef;//medrona ait olmayan beaconlar için, abcd değil
                         PACKED_Data[say].MYDATA[3] = 0xab;
                         
                         PACKED_Data[say].MYDATA[4] = 0x07;// tipi elle girilmiş.
                         PACKED_Data[say].MYDATA[5] = 0x00;                
                 } 
                 
            /*      if ((   params->peerAddr[5] ==0xC7      &&   params->peerAddr[4] ==0x6E
                       && params->peerAddr[3] ==0x50      &&   params->peerAddr[2] ==0x70 
                       && params->peerAddr[1] ==0x64      &&   params->peerAddr[0] ==0x6E))
                 {  
                         PACKED_Data[say].RSSI = (params->rssi) * -1;
                         PACKED_Data[say].LENGTH = 14; //params->advertisingDataLen;
                         PACKED_Data[say].PAKET_LENGTH = 6 + 1 + 1 + 14; //MAC+RSSI+1+LENGTH  
                       
                         pc.printf("TOPLAM PAKET UZUNLUK = (%d ) : ---> ", PACKED_Data[say].PAKET_LENGTH);          
                         PACKED_Data[say].MYDATA[0] = 0x07;
                         PACKED_Data[say].MYDATA[1] = 0xff;
                         
                         PACKED_Data[say].MYDATA[2] = 0xef;//medrona ait olmayan beaconlar için, abcd değil
                         PACKED_Data[say].MYDATA[3] = 0xab;
                         
                         PACKED_Data[say].MYDATA[4] = 0x06;// tipi elle girilmiş.
                         PACKED_Data[say].MYDATA[5] = 0x00;      
                         
                         PACKED_Data[say].MYDATA[6] = params->advertisingData[6];// x
                         PACKED_Data[say].MYDATA[7] = params->advertisingData[7];      
                         
                         PACKED_Data[say].MYDATA[8] = params->advertisingData[8];//y
                         PACKED_Data[say].MYDATA[9] = params->advertisingData[9];      
                         
                         PACKED_Data[say].MYDATA[10] = params->advertisingData[10];// z
                         PACKED_Data[say].MYDATA[11] = params->advertisingData[11];      
                         
                         PACKED_Data[say].MYDATA[12] = params->advertisingData[12];// pil
                         PACKED_Data[say].MYDATA[13] = params->advertisingData[13];      
                                   
                 } */
                             
                 say++;
            }
          
          }
 
  
  static const uint16_t MED_KIMLIK = 0xABEF;
  AdvertisingData_t *pAdvData;
  size_t index = 0;
  while (index < params->advertisingDataLen) 
  {
    pAdvData = (AdvertisingData_t *)&params->advertisingData[index];
    if (pAdvData->dataType == GapAdvertisingData::MANUFACTURER_SPECIFIC_DATA) 
    {
      ApplicationData_t *pAppData = (ApplicationData_t *)pAdvData->data;
      if (pAppData->applicationSpecificId == MED_KIMLIK)
      {
                        
           PACKED_Data[say].MacID[5]=params->peerAddr[5];
           PACKED_Data[say].MacID[4]=params->peerAddr[4];
           PACKED_Data[say].MacID[3]=params->peerAddr[3];
           PACKED_Data[say].MacID[2]=params->peerAddr[2];
           PACKED_Data[say].MacID[1]=params->peerAddr[1];
           PACKED_Data[say].MacID[0]=params->peerAddr[0];
           PACKED_Data[say].RSSI=(params->rssi) * -1;
           PACKED_Data[say].LENGTH=params->advertisingDataLen;
 
           PACKED_Data[say].PAKET_LENGTH= 6 + 1 + 1 + params->advertisingDataLen;//MAC+RSSI+1+LENGTH
            
           pc.printf("TOPLAM PAKET UZUNLUK = (%d ) : ---> ",PACKED_Data[say].PAKET_LENGTH); 

            for (unsigned index = 0; index < params->advertisingDataLen; index++)
            {
              PACKED_Data[say].MYDATA[index]=params->advertisingData[index];
            }      
            
            for (unsigned index = params->advertisingDataLen; index < 50; index++)
            {
              PACKED_Data[say].MYDATA[index]=0x00;
            } 
            
            say++;
        break;
      }
    }
    index += (pAdvData->length + 1);
  }
  
              
               for (unsigned i = 0; i < say; i++)
               { 
                 uint8_t buffertoSpi[bufferSize];

                 for (unsigned a = 0; a < bufferSize; a++)
                 {
                      buffertoSpi[a]=0x00;
                 } 
                  
                 buffertoSpi[0]=PACKED_Data[i].PAKET_LENGTH;
                 
                 for (unsigned a = 1; a < 7; a++)
                 { 
                    buffertoSpi[a]= PACKED_Data[i].MacID[6-a];
                 } 
                 
                 buffertoSpi[7]=PACKED_Data[i].RSSI; 
                 buffertoSpi[8]=PACKED_Data[i].LENGTH;
                 
                 for (unsigned a = 0; a < PACKED_Data[i].LENGTH; a++)
                 {
                    buffertoSpi[9+a]=PACKED_Data[i].MYDATA[a];
                 }
                 
                 pc.printf("nRF51 to stm32f103 SENT (BEACON NUMBER = %d )   :  ",i); 
                 
                 for (unsigned a = 0; a < bufferSize; a++)
                 {
                      pc.printf("%02x",buffertoSpi[a]);
                 } 
                  pc.printf("\r\n");
                   
                // SPI ÜZERİDEN HAZIRLANAN OLUŞTURULAN PAKET VERİ STM32F103'E GÖNDERİLİR. 
                //PAKET VERİMİZİ ŞÖYLEDİR;
                /* TPU + MAC_ID + RSSI + LEN + BEACONDAN OKUNAN VERİLER
                   "
                   TPU : TOPLAM PAKET BYTE UZUNLUGU 
                   LEN : BEACONDAN OKUNAN VERİLER TOPLAM BYTE UZUNLUGU 
                 
                 */    
                 
                if(esp_baglimi)
                {
                    Flash_Buff_WriteBytes(0, buffertoSpi, bufferSize); //eger esp nete baglandıysa göndermeye basla // 13072017
                }   

                
                //wait_ms(200); // hakan ekledi 01122016
                wait_ms(1);                    
                bulunan_index[i]=0x00;                 
               }
              say=0;
}

/**
   This function is called when the ble initialization process has failed
*/
void onBleInitError(BLE &ble, ble_error_t error)
{
  /* Initialization error handling should go here */
}

/**
   Callback triggered when the ble initialization process has finished
*/
void bleInitComplete(BLE::InitializationCompleteCallbackContext *params)
{
  BLE&        ble   = params->ble;
  ble_error_t error = params->error;

  if (error != BLE_ERROR_NONE) {
    /* In case of error, forward the error handling to onBleInitError */
    onBleInitError(ble, error);
    return;
  }

  /* Ensure that it is the default instance of BLE */
  if (ble.getInstanceID() != BLE::DEFAULT_INSTANCE) {
    return;
  }

  /* Setup and start scanning */
  ble.gap().setScanParams(100 /* scan interval */, 100 /* scan window */);
  ble.gap().startScan(advertisementCallback);

}

int main(void)
{
  pc.baud(115200); //local terminal baud
  pc.printf("----MEDRON TEKNOLOJİ SNIFFER---- \r\n"); 
  mac_id_gir();
  
  while(!esp_baglimi)
  {
      wait_ms(1);
  }
  SPI1.begin();
  BLE &ble = BLE::Instance();
  ble.init(bleInitComplete);

  while (true)
  {
    ble.waitForEvent();
  }
}
