#include "mbed.h"
#include "spi_master.h"
//# SCK     P0_25
//# MOSI    P0_20
//# MISO    P0_22
//# CS      P0_7
SPISlave device(p20,p22,p25,p7);
Serial pc(USBTX, USBRX);

int main(void)
{   
    pc.baud(9600);
    pc.printf("SPI Demo Start\r\n");
     
    device.format(8,0);        
    device.frequency(4000000); // 4MHz
 
    uint8_t reply = 20;
    device.reply(reply);              // Bu satiri commentleyince çalışmıyor doğru, nedenini anlamadim.
 
    pc.printf("======================================================\r\n");
    pc.printf("Startup Next reply will be %d\r\n", reply);
 
    while (1) {
        if (device.receive()) 
        {
            int valueFromMaster = device.read();
            device.reply(reply++);     // Prime SPI with next reply
            pc.printf("Received value from Master (%d) Next reply will be %d \r\n", valueFromMaster, reply);
        }
    } 
}