#include "mbed.h"
#include "spi_master.h"
//# SCK     P0_25
//# MOSI    P0_20
//# MISO    P0_22
//# CS      P0_7
DigitalOut spi_cs(P0_7);
SPIClass SPI1(NRF_SPI1);
Serial pc(USBTX, USBRX);

uint8_t i,izin=1;
uint8_t wt_buf[] = "DENEMEE";
uint8_t rd_buf[7];
uint32_t x=0;


uint8_t DATA_1[50]={0x07,0xdd,0xcc,0xee,0x15,0x23,0x56,0x11,0x33};


void WriteBytes(uint16_t addr, uint8_t *pbuf, uint16_t len)
{
    uint16_t index;
    spi_cs = 0;
    wait_us(20);     
    for(index=0; index<len; index++)
    {
        SPI1.transfer(*pbuf);
        pbuf++;        
    }
    
    wait_us(20);
    spi_cs = 1;
}

void ReadBytes(uint16_t addr, uint8_t *pbuf, uint16_t len)
{
    uint16_t index;
    
    spi_cs = 0;
    wait_us(5);   
    for(index=0; index<len; index++)
    {
        *pbuf = SPI1.transfer(0x00);
        pbuf++;        
    }
    spi_cs = 1;
}

int main(void)
{   
    pc.baud(9600);
    SPI1.begin(); //SPI1.begin(P0_6, P0_15, P0_29);//SCK, MOSI, MOSI
    pc.printf("SPI Demo Start\r\n");
    while(1)
    {
 
         WriteBytes(0, DATA_1, sizeof(DATA_1));
         for(i=0; i<sizeof(DATA_1); i++)
         {
             pc.printf("%02x",DATA_1[i]);
         }
         pc.printf("  %d \r\n",x);
   
         
         wait(1);
         
         
    }
}