 /* Copyright 2011 Adam Green (http://mbed.org/users/AdamGreen/)

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
/* Uses a Sparkfun Thumb Joystick to control the X and Y coordinate returned
   from the mbed device acting as a HID based absolute mouse.
   
   More information about the analog joystick and associated breakout board can
   be found at the following URL: http://www.sparkfun.com/products/10433
   
                 Connections
   +-------------------+---------------+ 
   | Joystick Breakout | mbed          |
   | VCC               | pin 40 - VOUT |
   | VERT              | pin 15 - p15  |
   | HORZ              | pin 16 - p16  |
   | SEL               | Not Connected |
   | GND               | pin 1  - GND  |
   +-------------------+---------------+ 
   
   The following notebook page shows how to connect a SparkFun USB breakout
   board to mbed pin 31 (D+) & pin 32 (D-).
    http://mbed.org/users/romilly/notebook/unboxing-the-lpc11u24/
   
   Notebook page describing this program can be found here:
    http://mbed.org/users/romilly/notebook/unboxing-the-lpc11u24/
*/
#include <mbed.h>
#include <USBMouse.h>

 int main(void)
 {
    static const float      Width = (float)(X_MAX_ABS - X_MIN_ABS);
    static const float      Height = (float)(Y_MAX_ABS - Y_MIN_ABS);
    AnalogIn                AnalogX(p15);
    AnalogIn                AnalogY(p16);
    USBMouse                Mouse(ABS_MOUSE);
   
    while (1)
    {
        float AnalogXReading = AnalogX.read();
        float AnalogYReading = 1.0f - AnalogY.read();

        uint16_t X = X_MIN_ABS + (uint16_t)(Width * AnalogXReading);
        uint16_t Y = Y_MIN_ABS + (uint16_t)(Height * AnalogYReading);
        
        Mouse.move(X, Y);
        wait(0.01f);
    }
 }