/* Copyright 2011 Adam Green (http://mbed.org/users/AdamGreen/)

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
/* Interfaces to a Sparkfun Blackberry Trackball Breakout Board and uses mbed's
   USBMouse class to make it look like a mouse to a PC.  Uses the trackball
   motion to move the mouse pointer, pushing down on the trackball will trigger
   a microswitch which will act as a left button click, and the LEDs under the
   trackball will be lit different colours depending on what the user is
   currently doing with the device (red for no motion, green when the trackball
   is being moved, and blue during button clicks).  It does use some other
   utility classes from acceleration.h to provide acceleration to the trackball
   motion.
*/
#include <mbed.h>
#include <USBMouse.h>
#include "acceleration.h"



int main() 
{
    static USBMouse                 Mouse;
    static CAcceleratedTrackball    Trackball(p20,  // BLU
                                              p25,  // RED
                                              p26,  // GRN
                                              p10,  // WHT
                                              p5,   // UP
                                              p6,   // DWN
                                              p7,   // LFT
                                              p8,   // RHT
                                              p9);  // BTN
    
    for(;;)
    {
        int DeltaX;
        int DeltaY;
        int ButtonPressed;        
        
        Trackball.GetState(DeltaX, DeltaY, ButtonPressed);

        Mouse.update(DeltaX, 
                     DeltaY, 
                     ButtonPressed ? MOUSE_LEFT : 0, 
                     0);
    }
}
