/** Sample program to read temperature and humidity
 *
 * @author Alex Lipford
 * Georgia Institute of Technology 
 * ECE 4180 Embeded Systems Design
 * Professor Hamblen
 * 10/19/2014
 * 
 * @section LICENSE
 * ----------------------------------------------------------------------------
 * "THE BEER-WARE LICENSE" (Revision 42):
 * <alexlipford@gmail.com> wrote this file. As long as you retain this notice you
 * can do whatever you want with this stuff. If we meet some day, and you think
 * this stuff is worth it, you can buy me a beer in return.
 * ----------------------------------------------------------------------------
 *
 *
 * @section DESCRIPTION
 *
 * Honeywell HTU21D Humidity and Temperature sensor.
 *
 * Datasheet, specs, and information:
 *
 * https://www.sparkfun.com/products/12064
 */
 
#include "mbed.h"
#include "HTU21D.h"

HTU21D temphumid(PB_14, PB_13); //Temp humid sensor || SDA, SCL
int sample_ftemp;
int sample_ctemp;
int sample_ktemp;
int sample_humid;

int main() {
    while(1) {
        sample_ftemp = temphumid.sample_ftemp();
        sample_ctemp = temphumid.sample_ctemp();
        sample_ktemp = temphumid.sample_ktemp();
        sample_humid = temphumid.sample_humid();
        printf("Temperature: %d F\n\r", sample_ftemp);
        printf("Temperature: %d C\n\r", sample_ctemp);
        printf("Temperature: %d K\n\r", sample_ktemp);
        printf("Humidity: %d %%\n\r", sample_humid);
        printf("\n\r");
        wait(5);
    }
}
