#include "mbed.h"
#include "LM75B.h"
#include "C12832_lcd.h"


DigitalOut myled1 (LED1); 
DigitalOut myled2 (LED2); 
DigitalOut myled3 (LED3);
DigitalOut myled4 (LED4);
Serial pc(USBTX,USBRX); // setup terminal link
LocalFileSystem local("local"); // define local file system
int write_var;
int read_var;
C12832_LCD lcd;
LM75B tmp(p28,p27); //I2C Temperature Sensor

PwmOut r(p23); //RGB LED with 3 PWM outputs for dimmer control
PwmOut g(p24);
PwmOut b(p25);

PwmOut speaker(p26); //Speaker with PWM driver

BusIn joy(p15,p12,p13,p16); //joystick


AnalogIn pot1(p19); //Reads Pot 1 - near LCD
AnalogIn pot2(p20); //Reads Pot 2 - near RGB LED

int main ()
{
    
    
    float board_temp;
    float alarm_temp = 0.0;
    // generate a 800Hz tone using PWM hardware output
    speaker.period(1.0/800.0); // 800hz period
    r=1.0; //RGB LED off - PWM 100% duty cycle
    g=1.0;
    b=1.0;
    
    //zakuan
        lcd.cls();
        lcd.locate(1,1); //clears LCD
        lcd.printf("Welcome to Heat Monitoring System");
        wait(3.0);
    
    //
    while (1) {
        lcd.cls();
        lcd.locate(0,0); //clears LCD
        board_temp = tmp; //read temperature
        lcd.printf("Board Temperature = %.2f\n\r",board_temp);
        alarm_temp = 50 * pot1; //read alarm temp
        lcd.printf("Temperature Limit = %.2f\n\r",alarm_temp);
       
        if(board_temp > alarm_temp) { //check temp for alarm
            r = 1.0 - pot2;
            wait(0.1); //RGB LED red
            
        
            speaker = 0.9;
            
            lcd.cls();
            lcd.locate(0,0);
            lcd.printf("!!! ...WARNING OVERHEAT... !!!");
            wait(3.0);
          
            myled1 = 1; 
            myled2 = 0;
            myled3 = 0; 
            myled4 = 0; 
            wait(0.1); 
            
            myled1 = 0; 
            myled2 = 1;
            myled3 = 0; 
            myled4 = 0; 
            wait(0.2); 
            
            myled1 = 0; 
            myled2 = 0;
            myled3 = 1; 
            myled4 = 0; 
            wait(0.1); 
            
             myled1 = 0; 
            myled2 = 0;
            myled3 = 0; 
            myled4 = 1; 
            wait(0.1); 
            
            r=1.0;
            g=1.0;
            b=1.0;  
        } 
        else {
            g = 1.0 - pot2; //RGB LED green
            r = 1.0;
            speaker = 0.0;
        }
        wait(1.0);
        pc.printf("%.2f\n\r",board_temp); //send temp to PC
        FILE* File1 = fopen("/local/datafile.txt","w");
        write_var=0x23; // example data
        fputc(write_var, File1);
        fclose(File1);
    }
}
