#include "mbed.h"
#include "stm32f103c8t6.h"
//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
//------------------------------------

Serial pc(SERIAL_TX, SERIAL_RX);

DigitalOut myled(LED1);

int main()
{
    float meas;
    float very_hum_value = 0.27;
    float soil_hum_perc;
         
    AnalogIn analog_value(A0);
    DigitalOut VCC(PB_7);
    
    while(1) {
       
        VCC = 1;// VCC on
        wait(1);
        meas = analog_value.read();
        VCC = 0; //VCC of
        
        soil_hum_perc = (1 - (meas - very_hum_value)/(1 - very_hum_value)) * 100; // perevod v %
        pc.printf("Soil_Humidity: %f %% \n", soil_hum_perc);
        
        wait(600); //period izmereniy
    }
}
