#include "mbed.h"
#include <math.h>
#include <string.h>
#include "SDFileSystem.h" 
#include <iostream>
using namespace std;

SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd");

Serial pc(USBTX, USBRX);            // And a little feedback

Timer t;
Timer ReadClock;

int  bufcnt,lineCnt,prtCnt,ended,timeout,Multiplier,Port_SensorID[11];
float Port_Multiplier[11];
char buf[1024];
char snd[1024];
char text[1024];
//char SensorType[100];
char Port_Description[11][100];
char Board_specs[10][50];// Board_specs[1]= Board-id, Board_specs[2]=WIFI ssid, Board_specs[3]=Wifi-Password,Board_specs[4]=Database TableName. 
int brdspCnt=0;
void SDcrdRead();
char readConfigText();
float UnitConversion(int Sens_ID);
char *SensorName(int Sens_ID);
 FILE * fp;

AnalogIn Port_1(PTB2);// Current Sensor -> Output 0-2.5V dc Measures 0-600Amps
AnalogIn Port_2(PTB3);// Pressure Sensor -> Output 0-5V dc Measures 0-200Psig
AnalogIn Port_3(PTB10);// Temperature Sensor -> Output 0-5V dc Measures 0-50 degree Celcius
AnalogIn Port_4(PTB11);// CO2 Sensor -> Output 0-10V dc Measures 0-2000ppm
AnalogIn Port_5(PTC11);// CO2 Sensor -> Output 0-10V dc Measures 0-2000ppm
AnalogIn Port_6(PTC10);// CO2 Sensor -> Output 0-10V dc Measures 0-2000ppm
AnalogIn Port_7(PTC2);// CO2 Sensor -> Output 0-10V dc Measures 0-2000ppm
AnalogIn Port_8(PTC0);// CO2 Sensor -> Output 0-10V dc Measures 0-2000ppm
AnalogIn Port_9(PTC9);// CO2 Sensor -> Output 0-10V dc Measures 0-2000ppm
AnalogIn Port_10(PTC8);// CO2 Sensor -> Output 0-10V dc Measures 0-2000ppm
float Port_1val,Port_2val,Port_3val,Port_4val,Port_5val,Port_6val,Port_7val,Port_8val,Port_9val,Port_10val;
//float PressureVal,TempVal,CurrentVal,CO2Val;
float AvgPort_1Val,AvgPort_2Val,AvgPort_3Val,AvgPort_4Val,AvgPort_5Val,AvgPort_6Val,AvgPort_7Val,AvgPort_8Val,AvgPort_9Val,AvgPort_10Val;
float Port_1ValSum,Port_2ValSum,Port_3ValSum,Port_4ValSum,Port_5ValSum,Port_6ValSum,Port_7ValSum,Port_8ValSum,Port_9ValSum,Port_10ValSum;
int  Count,ClockOut;


//DigitalIn OA2(D2);
void SDcrdRead(void){
    //FILE * fp;
    
    printf("\r\nReading from SD card...\r\n\n\n");
    fp = fopen("/sd/IAC_Config_File.txt", "rb");
    if (fp != NULL) {        
        readConfigText();        
        fclose(fp);
        printf(" \r\n\r\n\r\nRead Successfully!\r\n\r\n\r\n");
        printf(" \r\n\r\n\r\n ---- Config File ---- \r\n\r\n\r\n");
        printf("%s\n", text);
        printf(" \r\n\r\n\r\n ---- End of Config File ---- \r\n\r\n\r\n");
    } 
    else {
        printf("\nReading Failed!\r\n");
    }

}


char readConfigText()
{
    memset(buf, '\0', sizeof(buf));
    t.start();
    ended=0;
    bufcnt=0;
    lineCnt=0;
    prtCnt =0;    
    while(true) {        
        char C = fgetc(fp);
        //if(t.read() <= timeout) {
        buf[bufcnt] = C; 
        bufcnt++;           
        //printf(buf);
        if(feof(fp)){
            break;        
        }            
        if(C == '\n'){
            //buf[bufcnt] = '\0';
            lineCnt++;                 
            strcpy(snd,buf);
            strcat(text,snd);
            if(buf[0]=='B'){                
                const char s[2] = ":";
                char *token;
               
                /* get the first token */
                token = strtok(buf, s);
                /* get the other tokens there*/
                while( token != NULL ) {
                      brdspCnt++;
                      strcpy(Board_specs[brdspCnt],token);
                      printf( " Boardspec[%d] = %s\r\n\n",brdspCnt, Board_specs[brdspCnt] );
                    
                      token = strtok(NULL, s);
                }
               
                
                
            }
            else if(buf[0]=='P'){
                prtCnt++;                
                if (prtCnt<10){                    
                    Port_SensorID[prtCnt]=int(buf[9]-'0');
                    Port_Multiplier[prtCnt]= UnitConversion(Port_SensorID[prtCnt]);
                    char *senStr = SensorName(Port_SensorID[prtCnt]);
                    strcpy(Port_Description[prtCnt],senStr);                   
                    
                    printf("%d  %0.2f    %s\r\n",Port_SensorID[prtCnt],Port_Multiplier[prtCnt],Port_Description[prtCnt]);
                }
                else{
                    Port_SensorID[prtCnt]=int(buf[10]-'0');
                    Port_Multiplier[prtCnt]= UnitConversion(Port_SensorID[prtCnt]);
                    char *senStr = SensorName(Port_SensorID[prtCnt]);
                    strcpy(Port_Description[prtCnt],senStr);
                    
                    printf("%d  %0.2f    %s\r\n",Port_SensorID[prtCnt],Port_Multiplier[prtCnt],Port_Description[prtCnt]);
                }
                    
            }
            //printf(text); 
            memset(buf, '\0', sizeof(buf));
            bufcnt = 0;
        }        
        
    }
    
    printf("\r\n End of text file \r\n");
    printf("\r\nLine Count %d\r\n",lineCnt);
}

float UnitConversion(int Sens_ID){
    switch (Sens_ID){
        case 0 :
            Multiplier = 0.0;
            break;
        case 1 :
            Multiplier = 2000.0;
            break;
        case 2 :
            Multiplier = 133.33;
            break;
        case 3 :
            Multiplier = 800.00;
            break;
        case 4 :
            Multiplier = 50.0;
            break;
        case 5 :
            Multiplier = 50.0;
            break;
        case 6 :
            Multiplier = 200.0;
            break;
        case 7 :
            Multiplier = 100.0;
            break;
        case 8 :
            Multiplier = 100;
            break;       
        }
    return Multiplier;
}

char *SensorName(int Sens_ID){
    
    static char *strng ;
    //memset(strng, '\0', sizeof(strng));
    
    switch (Sens_ID){
        case 0 :
            strng = "Null";
            break;
        case 1 :
            strng = "Carbondioxide - Parts per million";
            break;
        case 2 :
            strng = "Current 0-100 Ampere";
            break;
        case 3 :
            strng = "Current 0-600 Ampere";
            break;
        case 4 :
            strng = "Temperature 0-50 Degree Celsius";
            break;
        case 5 :
            strng = "Temperature 0-50 Degree Celsius";
            break;
        case 6 :
            strng = "Pressure (PSIG)";
            break;
        case 7 :
            strng = "Humidity - Percentage";
            break;
        case 8 :
            strng = "Compressed Airflow - Percentage";
            break;       
        }
    return strng;
}

int main(){
    SDcrdRead();    
    while(true){
        ClockOut = 5;
        ended=0;
        Count=0;
        Port_1ValSum = 0.0;
        Port_2ValSum = 0.0;
        Port_3ValSum = 0.0;
        Port_4ValSum = 0.0;
        Port_5ValSum = 0.0;
        Port_6ValSum = 0.0;
        Port_7ValSum = 0.0;
        Port_8ValSum = 0.0;
        Port_9ValSum = 0.0;
        Port_10ValSum = 0.0;
        
        while (ended!=1) {          
          ReadClock.start();
          Port_1val = Port_1.read()*Port_Multiplier[1];
          Port_2val = Port_2.read()*Port_Multiplier[2];
          Port_3val = Port_3.read()*Port_Multiplier[3];
          Port_4val = Port_4.read()*Port_Multiplier[4];
          Port_5val = Port_5.read()*Port_Multiplier[5];
          Port_6val = Port_6.read()*Port_Multiplier[6];
          Port_7val = Port_7.read()*Port_Multiplier[7];
          Port_8val = Port_8.read()*Port_Multiplier[8];
          Port_9val = Port_9.read()*Port_Multiplier[9];
          Port_10val = Port_10.read()*Port_Multiplier[10];        
          
          Port_1ValSum += Port_1val;
          Port_2ValSum += Port_2val;
          Port_3ValSum += Port_3val;
          Port_4ValSum += Port_4val;
          Port_5ValSum += Port_5val;
          Port_6ValSum += Port_6val;
          Port_7ValSum += Port_7val;
          Port_8ValSum += Port_8val;
          Port_9ValSum += Port_9val;
          Port_10ValSum += Port_10val;          
          Count++;       
          //printf(" %f %f %f %f \r\n", CurrentVal, PressureVal, TempVal, CO2Val); 
          printf(" %f %f %f %f %f %f %f %f %f %f\r\n", Port_1val, Port_2val, Port_3val, Port_4val,Port_5val, Port_6val, Port_7val, Port_8val,Port_9val, Port_10val);      
          wait(0.002f);
          if(ReadClock.read() > ClockOut) {
                ended = 1;
                ReadClock.stop();
                ReadClock.reset();
          }
          
        }
        AvgPort_1Val=Port_1ValSum/Count;
        //AvgPort_1Val =ceilf(AvgPort_1Val * 10) / 10;
        AvgPort_2Val=Port_2ValSum/Count;
        //AvgPort_2Val =ceilf(AvgPort_2Val * 10) / 10;
        AvgPort_3Val=Port_3ValSum/Count;
        //AvgPort_3Val =ceilf(AvgPort_3Val * 10) / 10;
        AvgPort_4Val=Port_4ValSum/Count;
        //AvgPort_4Val =ceilf(AvgPort_4Val * 10) / 10;
        AvgPort_5Val=Port_5ValSum/Count;
        //AvgPort_5Val =ceilf(AvgPort_5Val * 10) / 10;
        AvgPort_6Val=Port_6ValSum/Count;
        //AvgPort_6Val =ceilf(AvgPort_6Val * 10) / 10;
        AvgPort_7Val=Port_7ValSum/Count;
        //AvgPort_7Val =ceilf(AvgPort_7Val * 10) / 10;
        AvgPort_8Val=Port_8ValSum/Count;
        //AvgPort_8Val =ceilf(AvgPort_8Val * 10) / 10;
        AvgPort_9Val=Port_9ValSum/Count;
        //AvgPort_9Val =ceilf(AvgPort_9Val * 10) / 10;
        AvgPort_10Val=Port_10ValSum/Count;
        //AvgPort_10Val =ceilf(AvgPort_10Val * 10) / 10;      
        
        printf("%f %f %f %f %f %f %f %f %f %f %d \r\n", AvgPort_1Val,AvgPort_2Val,AvgPort_3Val,AvgPort_4Val,AvgPort_5Val,AvgPort_6Val,AvgPort_7Val,AvgPort_8Val,AvgPort_9Val,AvgPort_10Val,Count); 
        wait(2); 
        
    }
        
        
    
    
 

    
}