//送信側マイコン nucleo_f103rb

#include "mbed.h"
#include "servo_motor.h"
#include "ps3_controller.h"
#include "dc_motor_1.h"
#include "rotary_encoder.h"
#include "CANnucleo.h"
#include "servo_motor_270.h"


/***初期化関数**************************************/

Serial      pc(USBTX,USBRX);
ps3_cont    ps3(PC_10,PC_11);
Timer       system_cycle;
CAN*        can;
CANMessage   txMsg;


//センサー類
rotary_encoder enco1(PA_13,PA_14,NC,500,rotary_encoder::X4_ENCODING);
rotary_encoder enco2(PC_0,PC_3,NC,500,rotary_encoder::X4_ENCODING);
rotary_encoder enco3(PC_15,PD_2,NC,500,rotary_encoder::X4_ENCODING);

//アクチュエータ類
dc_motor_1 motor1(A3,A2,1);     //tiemr_3_3
dc_motor_1 motor2(D4,A4,1);     //timer_3_2
dc_motor_1 motor3(D5,A0,1);     //timer_3_1

ServoMotor_270 servo1(PB_13);       //timer_1_1N

DigitalOut LED[3]={D12,D11,D10};
DigitalOut button[2]={D9,D8};

DigitalOut buzzer(PC_8);

/********グローバル変数******************************/

const unsigned int TX_ID = 0x101;
uint8_t     counter = 0;

/**************************************************/

void print_Msg(CANMessage &msg){
    pc.printf("sent_date =");
    for(int i=0 ; i<msg.len ; i++){
        pc.printf("0x%.2X\t",msg.data[i]);
    }
}

int main()
{
    float init_deg1 = 180.0;
    float init_deg2 = 0.0;
    float deg1 = 180.0;
    float deg2 = 0.0;
    
    pc.baud(9600);
    can = new CAN(PA_11,PA_12);
    can -> frequency(1000000);
    system_cycle.start();
    pc.printf("program_start!!");
    
    while(1){
        while( (system_cycle.read_ms() >= 20) ){

            txMsg.clear();
            txMsg.id = TX_ID;
            txMsg << counter;
            
            if(can->write(txMsg)){
                print_Msg(txMsg);
            }
            else{
                pc.printf("sent_error/r/n");
            }
            
            if( ps3.getbutton(square)==1){
                motor1.drive(20.0);
                LED[0].write(1);
            }
            else if( ps3.getbutton(triangle)==1){
                motor2.drive(20.0);
                LED[1].write(1);
            }
            else if( ps3.getbutton(circle)==1){
                motor3.drive(20.0);
                LED[2].write(1);
            }
            else if( ps3.getbutton(left)==1){
                servo1.weak_condition();
            }
            else if( ps3.getbutton(right)==1){
                servo1.rot(0.0);
            }
            else if( ps3.getbutton(L1)==1){
                buzzer.write(1);
            }
            else if(ps3.getbutton(L2)==1){
                counter = 1;    
            }
            else if(ps3.getbutton(R2)==1){
                counter = 2;    
            }
            else if(ps3.getbutton(up)==1){
                counter = 3;
            }
            else if(ps3.getbutton(under)==1){
                counter = 4;
            }
            else if(button[0].read() == 1){
                LED[0].write(1);
            }
            else if(button[1].read() == 1){
                LED[1].write(1);
            }
            
            else{
                counter = 0;
                LED[1].write(0);
                LED[2].write(0);
                LED[0].write(0);
                buzzer.write(0);
                servo1.rot(265.0);
                motor1.drive(0.0);
                motor2.drive(0.0);
                motor3.drive(0.0);
            }
        
            pc.printf("%f\t %f\t %f\t %d\t  \r\n",enco1.getDeg(),enco2.getDeg(),enco3.getDeg(),buzzer.read());
            system_cycle.reset(); 
        }//(while system_cycle )
    if( ps3.getbutton(cross)==1){break;}
    }//(while)
}

