#include "F746_GUI.hpp"
#include "Table.h"

struct table_pins TablePins = {PB_4,PC_6,PC_7,PB_8,PB_9,PB_14,PB_15};
int speed_start = 10;
int speed_max = 1000;
int speed = 0;
DigitalIn FourcheLibre(PA_8);

int main()
{
    // ******** INIT GUI *********
    NumericLabel<int> bStart(380, 240, "Wait for Start", Label::LEFT, Font12, LCD_COLOR_MAGENTA);
    
    Button Start(250, 220, 120, 40, "START", Font12,
                      GuiBase::ENUM_TEXT, GuiBase::ENUM_BACK,
                      LCD_COLOR_DARKGREEN, LCD_COLOR_GREEN);
    
    Label stepY(130, 20, "STEPPERs Y", Label::CENTER, Font16);                  
    ButtonGroup bDir_Y(50, 70, 80, 50,  3, (string[]){"^","v","Pause"}, 0, 0, 2);
    bDir_Y.TouchedColor(2);
    NumericLabel<int> bDir_Y_label(130, 35, "", Label::CENTER , Font12);
    bDir_Y_label.Draw("Pause",1);
    NumericLabel<int> bCount_Y_label(130, 50, "", Label::CENTER , Font12);
    bCount_Y_label.Draw("Not started",1);
    
    Label stepX(320, 20, "STEPPER X", Label::CENTER, Font16);
    ButtonGroup bDir_X(260, 70, 80, 50,  3, (string[]){"<<",">>","Pause"}, 0, 0, 2);
    bDir_X.TouchedColor(2);
    NumericLabel<int> bDir_X_label(320, 35, "", Label::CENTER , Font12);
    bDir_X_label.Draw("Pause",1);
    NumericLabel<int> bCount_X_label(320, 50, "", Label::CENTER , Font12);
    bCount_X_label.Draw("Not started",1);  
    
    SeekBar barSpeed(20, 250, 200, 0, speed_max, speed_start, "0", "", "1000");
    NumericLabel<int> barSpeed_legend(110, 205, "Speed : 10", Label::CENTER , Font12);
    barSpeed_legend.Draw("Speed : %d",barSpeed.GetIntValue());  
    
    // ******** INIT STEPPER ******    
    table Table (TablePins);

    int first = 1;

// ***** WAIT FOR START *****
    while(!Start.Touched()){
        if (first){    
            bStart.Draw("Wait for Start",0);
            first = 0;
        }
        if (barSpeed.Slide()){ 
            speed = barSpeed.GetIntValue();
            barSpeed_legend.Draw("Speed : %d",barSpeed.GetIntValue());          
        }
    } 
    
// ******* RUN *****  
// ***************** 
    first = 1;
    
    while (true)
    {
        
        if (first){
            bStart.Draw("Started",1);
            first = 0;
        }
    }  
   
}



