#include "Stepper.h"

stepper::stepper(PinName _en, PinName _stepPin, PinName _dir):
    en(_en),
    stepPin(_stepPin),
    dir(_dir)
{
}

steppers::steppers(PinName _en, PinName _stepPin, PinName _dirG, PinName _dirD):
    stepper(_en,_stepPin,_dirG),
    dirD(_dirD)
{}
    
void stepper::step(int direction, float speed)
{
    if (direction == 1) {
        dir = 1;
    } else if (direction == 0) {
        dir = 0;
    }
    
    //  Step...
    stepPin = 1;
    wait(1/speed);
    stepPin = 0;
    wait(1/speed);
}

void steppers::step(int direction, float speed)
{
    if (direction == 1) {
        dirD = 1;
        dir = 0;
    } else if (direction == 0) {
        dirD = 0;
        dir = 1;
    }
    
    //  Step...
    stepPin = 1;
    wait(1/speed);
    stepPin = 0;
    wait(1/speed);
}

void stepper::enable()
{
    en = 0;
}

void stepper::disable()
{
    en = 1;
}