#include "mbed.h"
#include "FirmwareUpdater.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include "NTPClient.h"
#include "HTTPServer.h"
#include "RPCFunction.h"
 
EthernetNetIf eth;
FirmwareUpdater fwup("http://mbed.org/media/uploads/shintamainjp/", "firm_LPC1768", true); 
 
// There are 2 files for the firmware.
//  1. firm.txt : firmware version file.
//  2. firm.bin : firmware binary file.
 
void check_newfirm() {
    if (fwup.exist() == 0) {
        printf("Found a new firmware.\n");
        if (fwup.execute() == 0) {
            printf("Update succeed.\n");
            printf("Resetting this system...\n\n\n\n\n");
            fwup.reset();
        } else {
            printf("Update failed!\n");
        }
    }
}
 
int main(void) {
  
    eth.setup();
 
    check_newfirm();
    printf("Hi!");
    // Your application is here.   
}