#include "mbed.h"
#include <pulse1.h>
#include <string.h>
//Tarea de automatización de válvula para sanitario
PulseInOut irda(PTD5);          // Entrada del sensor infrarojo
Serial pc(USBTX, USBRX);        // módulos de transmisión y recepción
PwmOut l0(PTD0);                // pin de activación de la válvula
DigitalOut l1(LED1);
 
int header =0;                  //Cabecera inicial en cero
//Tiempo de cabecera de subida y bajada - 4520
const int head_H = 5424;        //+20% medida con osciloscopio en microsegundos
const int head_L = 3616;        //-20%  medida con osciloscopio
int i=0;
const int T_alto = 1680;        //ponga su tiempo de la prueba
const int T_bajo = 560;         //ponga su tiempo de la prueba
const int num_bits = 32;        //ponga su numero de bits
int num[num_bits];              //cadena para almacenar todos los tiempos que conforman los bits de datos
int aux[num_bits];              //Cadena auxiliar a comparar
int dato,prender,flag1;           

// Secuencia de encendido entregada por el botón POWER del control  
int power[]={1,0,1,1,0,1,0,0,1,0,1,1,0,1,0,0,0,0,0,0,1,1,0,0,1,1,1,1,0,0,1};
 
int main(){
 
    while(1){
 
ini1: 
        fflush( stdin );                //sirve para limpiar el buffer de entrada de teclado
        header=0;                       //cabecera inicial en cero
        l0=0;                           //LED's apagados inicialmente
        l1=0;                           
        header = irda.read_low_us();    //funcion para leer un pulso de caida o bajo
        if (header > head_L && header < head_H) goto seguir; //verificar que este en la tolerancia +-20%, si el header es mayor que el tiempo en alto, y si el header es menor que el tiempo en bajo
        else goto ini1;                 //vuelva a la función
 
seguir:
        //leo los datos de la trama y se meten a un arreglo
        wait_us(5000);                  //tiempo de espera 
        for(i=0;i<(num_bits-1);++i){   // POR OSCILOSCOPIO se determina que llegan (num_bits),datos
            dato = irda.read_high_us();   //leer un bit de datos que es un pulso arriba en este control
            num[i]=dato;                //asignación para construir el arreglo
            wait_us(500);   
        }
        
        wait(0.5);                      //espero antes de leer todo el arreglo y ponerlo en pantalla 
        pc.printf(",%d",header);        //imprime en pantalla el header (pulso)
        for(i=0;i<(num_bits-1);++i){    //Lee caracter por caracter del arreglo
            pc.printf(",%d",num[i]);     //imprime el arreglo construido
        }
        
        wait(0.1);                      //espero antes de imprimir el arreglo en binario
        pc.printf("     \n\n     ");                //imprimo en binario
        for(i=0;i<(num_bits-1);++i){                //Ciclo para leer los datos que llegan
            if(num[i] >((T_alto+T_bajo)/2)){        //si el arreglo es mayor que el promedio de tiempo de las cabeceras del arreglo del botón de encendido
                 pc.printf("1");                    //imprimo 1 en pantalla
                 aux[i]=1;                          //Ponemos en 1 el arreglo
            }
            else { 
            pc.printf("0");         //Si num[i] no cumple esta condición, se imprime 0 en pantalla
            aux[i]=0;               //Ponemos en cero el arreglo de 32 bits
            }
        }
        for(i=0;i<(num_bits-1);++i){  //Lectura de los caracteres del arreglo auxiliar
            pc.printf("%d",aux[i]);     //imprime el arreglo auxiliar
        }
//Se usará una interrupción, la cual determinará si existen caracteres distintos entre las dos cadenas (encendido y cadena enviada por el control) por medio de la desactivación
//de una bandera, si algún caracter es diferente...
        flag1=1;                //Bandera en alto
        for(i=0; i<31; ++i)     //Lectura de caracteres
        {
            if(aux[i]!=power[i]) //en caso de que un bit no coincida entre las dos cadenas
            {
                flag1=0;                    //Bandera en bajo
            }   
        }
//Se evaluará el estado de la bandera, si está en alto es porque la cadena enviada por el control es la correspondiente al botón de encendido
//por tanto el LED se encenderá, esta salida representa la válvula que se desea abrir por 6 segundos. De lo contrario, si la bandera está en bajo
//la válvula no se activará, debido a que se presionó un botón diferente al de encendido.
        if(flag1==1)            //Si la bandera está e alto...
        {
            fflush( stdin );        //Limpia el buffer
            l0=1;                   //Activación de los LEDS, en el caso del LED de la placa FRDMKL25Z, cambiará de color
            l1=1;                   
            pc.printf("  ON");//Muestra en pantalla que se prendió        
            wait(6);                //Duración de activación de la válvula
        }
        else { 
            fflush( stdin );
            l0=0;                   //LEDS desactivados (orden suministrada por otro botón)
            l1=0;
            pc.printf("   OFF");//Muestra en pantalla que se apagó
        }
    }
}
