#include "mbed.h"
#include "SRF05.h"
#include "DebouncedIn.h"

Serial pc(USBTX, USBRX);

// Declaración de pines para las puertas
// a partir de entradas analógicas
PwmOut servo1(PTB0);    // entrada analógica servo 1 - listo
PwmOut servo2(PTB1);    // entrada analógica servo 2 - listo
PwmOut servo3(PTB2);    // sentrada analógica servo 3 - listo

int STOP=0;                     // estado detenido inicializado en 0

//servo1.period(0.025);
//servo2.period(0.025);
//servo3.period(0.025);
//servo1.pulsewidth(0.00055);
//servo2.pulsewidth(0.0022);
//servo3.pulsewidth(0.0022);

// Declaración de pines de los motores
//DigitalOut motor1(PTC16);
//DigitalOut motor2(PTC13);
//DigitalOut enable(PTB3);

int motor1;
int motor2;

// Declaración de pines para los botones
DebouncedIn boton1(PTC11);
DebouncedIn boton2b(PTC10);
DebouncedIn boton2s(PTC6);
DebouncedIn boton3(PTC5);
DebouncedIn boton1i(PTC4);
DebouncedIn boton2i(PTC3);
DebouncedIn boton3i(PTC0);
DebouncedIn boton_p(PTC7);

// Declaración pines del sensor de ultrasonido
SRF05 sensor(PTD3,PTD1);

// Declaración pines digitales para los led's
DigitalOut led1(PTE5);
DigitalOut led2(PTE4);
DigitalOut led3(PTE3);

// Declaración pines de salida para el motor principal tipo PWM 
// Entradas tipo PWM Análogas para inversión de giro
PwmOut giro1(PTC1);    
PwmOut giro2(PTC2);
DigitalOut enable(PTB3);

//giro1.period_ms(20);
//giro2.period_ms(20);
    
//A continuación se describe el número de botones a usar
// los pisos del ascensor, el botón de paro
// y las distancias entre los pisos
int botones[4],pisos[3],paro;
int bussy=0;                    
float distancia;
float dist3=8.0;
float dist2=28.0;
float dist1=47.0;

// Pulsadores 
void pulsadores(void const *args){
    
    while(1) {
        if (boton_p.read()==1){    // Lectura de boton de paro
            STOP=1;           
            paro=1; 
            }
        if (boton1.read()==1){
            botones[0]=1; //luego irá al piso 1
            }
        if (boton2b.read()==1){
            botones[1]=1; //luego irá al piso 1
            }
        if (boton2s.read()==1){
            botones[2]=1; //luego irá al piso 1
            }
        if (boton3.read()==1){
            botones[3]=1; //luego irá al piso 1
            }
        if (boton1i.read()==1){
            pisos[0]=1; //luego irá al piso 1
            }
        if (boton2i.read()==1){
            pisos[1]=1;  //luego irá al piso 2
            }
        if (boton3i.read()==1){
            pisos[2]=1; //luego irá al piso 3
            }
      // Thread::wait(1000.0*0.02);
    }
}

void sensar(void const *args){
    
    while(1) {
        
        distancia=sensor.read(); //sensar
        
        //Thread::wait(1000.0*0.02);
        
        distancia=floor(distancia); 
    }
}
void subir(void){ 

    if(motor2==0){
        giro1.period_ms(20);
        giro2.period_ms(20);
        enable=1;
        motor1=1;
        
        //giro1=1;
        //motor2=0;
        //giro2=0;
        
        giro1.pulsewidth_ms(15);
        giro2.pulsewidth_ms(0);
        }
}
void bajar(void){
    
    if(motor1==0){
        giro1.period_ms(20);
        giro2.period_ms(20);
        enable=1;
        motor1=0;
        
        //giro1=0;
        //motor2=1;
        //giro2=1;
        
        giro1.pulsewidth_ms(0);
        giro2.pulsewidth_ms(8);
        }
}
void stop(void){          

    giro1.period_ms(20);
    giro2.period_ms(20);
    enable=0;
    motor1=0;
    
    //giro1=0;
    //motor2=0;
    //giro2=0;
    
    enable=0;
    giro1.pulsewidth_ms(0);
    giro2.pulsewidth_ms(0);
}

void tercero(void){
    
    bussy=1;
    botones[3]=0;
    pisos[2]=0;
    servo1.period(0.025);   
    servo1.pulsewidth(0.0008);
    servo2.period(0.025);   
    servo2.pulsewidth(0.0055);  
    servo3.period(0.025);   
    servo3.pulsewidth(0.0055);   

    int flag1=0,flag2=0;
    subir();
    
    while(1){
        
        if (botones[2]==1 && distancia>=dist2){
            flag2=1;
            }    
        
        if (flag2==1 && distancia==dist2 && flag1==0){
            stop();
            servo2.pulsewidth(0.0008); 
            wait(5);
            servo2.pulsewidth(0.0055);    
            flag1=1; 
            subir();    
            botones[2]=0;
            }
        
        if (botones[1]==1){
            pisos[1]=1; // va luego para el piso 2
            }

        if (distancia<=dist3){
            stop();
            servo3.pulsewidth(0.0008); 
            wait(5);
            servo3.pulsewidth(0.0055);
            break;
            }
        }
        bussy=0;
}

void segundo(void){
    
    botones[1]=0; 
    botones[2]=0;
    pisos[1]=0; 
    bussy=1;
    servo1.period(0.025);   
    servo1.pulsewidth(0.0008);
    servo2.period(0.025);   
    servo2.pulsewidth(0.0055);  
    servo3.period(0.025);   
    servo3.pulsewidth(0.0055);   

    if (distancia>(dist2+2.0)){
        subir(); 
        }
    else{
        
        if (distancia<(dist2-2.0)){
            bajar();}
            }
         
        while(1){
            if (distancia==dist2){
                stop();
                servo2.pulsewidth(0.0008); 
                wait(5);
                servo2.pulsewidth(0.0055);    
                break;
                }
        }
    bussy=0;
}

void primero(void){
        
        botones[0]=0;
        pisos[0]=0;
        bussy=1;
        servo1.period(0.025);   
        servo1.pulsewidth(0.0008);
        servo2.period(0.025);   
        servo2.pulsewidth(0.0055);  
        servo3.period(0.025);   
        servo3.pulsewidth(0.0055);   
        int flag1=0,flag2=0;
        bajar();
        
        while(1){
            
            if (botones[1]==1 && distancia<=dist2){
                flag2=1;
                }
            if (flag2==1 && distancia==dist2 && flag1==0){
                stop();
                servo2.pulsewidth(0.0008);
                wait(5);
                servo2.pulsewidth(0.0055);      
                flag1=1;  
                bajar();  
                botones[1]=0;
                }
            if(botones[2]==1){
                pisos[1]=1;
                }
            if (distancia>=dist1){
                stop();
                servo1.pulsewidth(0.0022);
                wait(5);
                servo1.pulsewidth(0.0008);
                break;
                }
        }
        bussy=0;
}

void bombillos(void const *args){
   
    while(1){
        
        if (motor2==1){
            if (distancia>=dist3 && distancia<dist2){
                led3=1;
                led2=0;
                led1=0;  
                }
            if (distancia>=dist2 && distancia<dist1){
                led3=0;
                led2=1;
                led1=0;     
                }  
            if (distancia>=dist1){
                led3=0;
                led2=0;
                led1=1;     
                }
        }
        if (motor1==1 || (motor1==0 && motor2==0)){
            
            if (distancia<=dist1 && distancia>dist2){
                led3=0;
                led2=0;
                led1=1;  
                }
            if (distancia<=dist2 && distancia>dist3){
                led3=0;
                led2=1;
                led1=0;     
                }
            if (distancia<=dist3){
                led3=1;
                led2=0;
                led1=0;     
                }
        }
        
        //Thread::wait(1000.0*0.02);
        
    }
}

void parar(void){

    servo1.period(0.025);   
    servo1.pulsewidth(0.0008);
    servo2.period(0.025);   
    servo2.pulsewidth(0.0055);  
    servo3.period(0.025);   
    servo3.pulsewidth(0.0055); 
    bajar();
    
    while(1) {
        if (distancia>=dist1){
            stop();
            servo1.pulsewidth(0.0008);
            botones[0]=0;
            botones[1]=0;
            botones[2]=0;
            botones[3]=0;
            pisos[0]=0;
            pisos[1]=0;
            pisos[2]=0;
            STOP=0;
            paro=0;
            break;
           }
    }
}

int main() {
    
    giro1.period_ms(20);
    giro2.period_ms(20);
    giro1.pulsewidth_ms(0);
    giro2.pulsewidth_ms(0);
    
    enable=0;
    motor1=0;
    motor2=0;
    led1=0;
    led2=0;
    led3=0;
    
    //Thread thread2(pulsadores);
    //Thread thread4(sensar);
    //Thread thread5(bombillos);
    
    botones[0]=0;
    botones[1]=0;
    botones[2]=0;
    botones[3]=0;
    pisos[0]=0;
    pisos[1]=0;
    pisos[2]=0;
    
    while(1) {
        if (paro==1 ){
            botones[0]=0;
            botones[1]=0;
            botones[2]=0;
            botones[3]=0;
            pisos[0]=0;
            pisos[1]=0;
            pisos[2]=0;
            STOP=0;
            paro=0;
            primero();
            }
        if (STOP==0 && bussy==0){
            
            if (pisos[0]==1){
                pisos[0]=0;
                primero();
                }
            if ( pisos[1]==1){
                pisos[1]=0;
                segundo();
                }
            if (pisos[2]==1){
                pisos[2]=0;
                tercero();
                }   
            if (botones[0]==0 && botones[1]==0 && botones[2]==0 && botones[3]==0){
                }
            if ( botones[3]==1){
                botones[3]=0; 
                tercero();
                }
            if (botones[1]==1 || botones[2]==1){
                botones[1]=0; 
                botones[2]=0; 
                segundo();
                }
            if (botones[0]==1 ){
                botones[0]=0;    
                primero();  
                }
        }
        
        //Thread::wait(1000.0*0.2);
        //myled = 0;
        //Thread::wait(1000.0*0.2);     
    }
}
