#include "mbed.h"

//#include "InterruptIn.h"
//#include "Serial.h"

// DECLARATIONS

    Serial pc(USBTX, USBRX);
    Serial BT(p28,p27);         // Specify Serial pins to be used for the Bluetooth test

//Digital Inputs

    DigitalIn Sw1(p24);         // Switch 1 Connected to pin 24, used for the Simple I/O test

//Digital Outputs

    DigitalOut DOut1(p25);      // Digital Output 1 connected to pin 25, used for Simple I/O test
    DigitalOut led2(LED2);
    DigitalOut led4(LED4);
    DigitalOut LoaCLK(p14);
    DigitalOut LoaSI(p13);

//Analog Inputs

    AnalogIn AnaInput1(p15);
    AnalogIn AnaInput2(p16);
    AnalogIn LoaAnalogIn(p20);

//Analog Outputs

    AnalogOut AOutput(p18);

//PWM Outs

    PwmOut PWM(p21);



// *************************************************************************
//                         Function Declarations
// *************************************************************************


char DisplayMenu(void){

    char Key;
    
    printf("\n\r-------------Robotics Test Program ----------\n");
    printf("\n\r Type number followed by enter:");
    printf("\n\r 1: Simple Input/Output Test");
    printf("\n\r 2: Digital Analaog Converter Test");
    printf("\n\r 3: Analog Digital Converter Test");
    printf("\n\r 4: Pulse Width Modulation Test");
    printf("\n\r 5: Timer interrupt Test");
    printf("\n\r 6: External interrupt Test");
    printf("\n\r 7: Linear Optical Array Test");
    printf("\n\r 8: Bluetooth SPI Test");
    printf("\n\r\n\r Selection = "); 
    
    Key = 0x7F & pc.getc();     // Restricts the selection to the ASCII table
    wait_ms(100);

    printf("\n\r------------------------------------------------");
    printf("\r\n     Pressed Key = %c",Key);
    printf("\n\r------------------------------------------------");

    return(Key);    // Returns the selection from the menu
}

int SimpleIO(){ 

    bool State;         // Defines boolean variable
    
    State = Sw1;                            // Stores the state of Sw1 so that it can be printed below
    printf("\r\n Logic Value = %x",State);  // Outputs the logic state
    DOut1 = Sw1;
    
    return 0;
}
    
int AOut(){
    char Key;
    printf("\n\rEnter a value");
    printf("\n\r Keypress = ");
    Key=0x7F & pc.getc();
    printf("\n\r-------------------------------------");
    printf("\r\n Pressed Key = %c",Key);
    printf("\n\r-------------------------------------");
    float K = Key;
    AOutput.write(K/128);
    printf("\n\rK = %2.2f",K);
    return 0;
}
    
int fAnalogIn(){
    printf("\n\r Pin 15 Input = %1.4f volts\n", AnaInput1.read()*3.3f);
    AOutput.write(AnaInput1.read());
    printf("\n\r Pin 16 Output = %1.4f volts\n", AnaInput2.read()*3.3f);
    return 0;
}

int PWMOut(){
    
    //Specify Period First
    char T[4] = "500";
    char PW[4] = "250";
    printf("\n\r\n\r-----Robotics PWM Options-----");
    
    printf("\n\rEnter a Period in milliSeconds (max 999):");
    pc.gets(T,4);
    long int P = strtol(T,NULL,10);
    PWM.period_ms(P);
    
    printf("\n\rEnter a Pulse Width in milliSeconds (max 999):");
    pc.gets(PW,4);
    long int W = strtol(PW,NULL,10);
    PWM.pulsewidth_ms(W);
    
    printf("\n\rPeriod in uS: %i", P);
    printf("\n\rPulse Width in uS: %i", W);
    float R = W/P;
    printf("\n\rDuty Cycle: %3.3f", R);
    
    
 return 0;   
}

void ExternalISR(void) {
     led2 = !led2;
}

void ExternalIntInit(){
    InterruptIn Collision(p8); // Interrupt source is p8
    Collision.rise(&ExternalISR); // Attach the address ExternalISR to a rising edge interrupt
    led2=0;
    printf("\r\nWaiting for external interrupts at p8 to toggle LED2.\r\n");
    do {}
    while (pc.getc()!='q'); // This will be interrupted.
}

void TimerISR(void) {
     led2 = !led2;
 }

void TimerIntInit(void) {
    Ticker PeriodicInt;
    char x;
    pc.printf("\n\r Periodic interrupts at LED2 and Timeout Interrupt at LED4\n\r");
    // Specify address of the TimerISR (Ticker) function and the interval between interrupts
    PeriodicInt.attach(&TimerISR, 0.0625);
    led4=0;
    led2=1;
    do{ x=pc.getc(); // Wait for periodic interrupts.
     }
    while (x!='q');
    led2 = 0;
}

void scan(short ScanData[]) {
    int j;
     LoaSI=1;
     LoaCLK=1;
     LoaSI=0;
     for(j=0;j<128;j=j+1){
         ScanData[j]=LoaAnalogIn.read_u16();
         LoaCLK=0; 
         delay_us(1);
         LoaCLK=1;
     }
     LoaCLK=0;
}


void LinearOpticalArrayTest(void) {
    int i;
    short ScanData[128];
    int IntegrationTime, Sum, Max, Min, Average, MaxPosition, MinPosition;
    char x;
    MinPosition=0; MaxPosition=0; IntegrationTime=1000;
    pc.printf("\n\n\r Generating clocking sequence for linear optical array.");
    pc.printf("\n\r Integration Time = %d",IntegrationTime);
    do {
     scan(ScanData);
     wait_us(IntegrationTime);
     scan(ScanData);
     if (pc.readable()){
     x=pc.getc();
     if (x=='q') break;
     else if (x=='i'){
     pc.printf("\n\n\rEnter Integration Time in microsconds.");
     pc.scanf("%d",&IntegrationTime);
     pc.printf("\n\rIntegration Time = %d",IntegrationTime);
     }
     else if(x=='l') {for(i=0; i<128; i=i+1) pc.printf("\n\n\r %d ", ScanData[i]);}
     Sum=0; Max=0; Min=131000;
     for(i=0; i<128; i=i+1) {
     Sum=Sum+ScanData[i];
     if(ScanData[i]>Max) {Max=ScanData[i]; MaxPosition=i;}
     if(ScanData[i]<Min) {Min=ScanData[i]; MinPosition=i;}
     }
     Average=Sum/128;
     pc.printf("\n\n\r Average = %d Max = %d MaxPosition = %d Min = %d Min Position = %d",Average,Max,MaxPosition,Min,MinPosition);
     }
 }
while(1);
pc.printf("\n\n\rTerminating clocking sequence for linear optical array.\n\r");
}

int BlueToothTest(){
    char x;
    BT.baud(9600);
    do{
        if (pc.readable()) {
            x = pc.getc(); //read keypress
            if(x == 13){
                BT.putc('\n'); //send to pc/mobile
                pc.putc('\n'); //echo to pc
                BT.putc('\r'); //send to pc/mobile
                pc.putc('\r'); //echo to pc
                }
            else{
                BT.putc(x); //send to pc/mobile
                pc.putc(x); //echo to pc
            }
            }
    }while(x != 'q');
    return 0;
}

int main() {
char Key;
//Initialize();
while(1) {
 Key=DisplayMenu();
 if(Key=='1') SimpleIO();                       //LAB 2.2
 else if(Key=='2') AOut();                       //LAB 2.3
 else if(Key=='3') fAnalogIn();                 //LAB 2.4
 else if(Key=='4') PWMOut();                   //LAB 2.5
 else if(Key=='5') TimerIntInit();              //LAB 2.6
 else if(Key=='6') ExternalIntInit();           //LAB 2.7
 else if(Key=='7') LinearOpticalArrayTest();    //LAB 2.8
 else if(Key=='8') BlueToothTest();             //LAB 2.9
 else printf("\r\nInvalid keypress entry.\r\n");
}
}
